/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.hql.ast.util;

import antlr.SemanticException;
import antlr.collections.AST;
import java.util.HashMap;
import java.util.Map;
import org.hibernate.MappingException;
import org.hibernate.QueryException;
import org.hibernate.dialect.function.SQLFunction;
import org.hibernate.engine.JoinSequence;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.hql.NameGenerator;
import org.hibernate.hql.ast.DetailedSemanticException;
import org.hibernate.hql.ast.QuerySyntaxException;
import org.hibernate.hql.ast.tree.SqlNode;
import org.hibernate.persister.collection.CollectionPropertyMapping;
import org.hibernate.persister.collection.QueryableCollection;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.persister.entity.PropertyMapping;
import org.hibernate.persister.entity.Queryable;
import org.hibernate.type.AssociationType;
import org.hibernate.type.CollectionType;
import org.hibernate.type.EntityType;
import org.hibernate.type.Type;
import org.hibernate.type.TypeFactory;

public class SessionFactoryHelper {
    private SessionFactoryImplementor sfi;
    private Map collectionPropertyMappingByRole;

    public SessionFactoryHelper(SessionFactoryImplementor sfi) {
        this.sfi = sfi;
        this.collectionPropertyMappingByRole = new HashMap();
    }

    public SessionFactoryImplementor getFactory() {
        return this.sfi;
    }

    public boolean hasPhysicalDiscriminatorColumn(Queryable persister) {
        String discrimColumnName;
        return persister.getDiscriminatorType() != null && (discrimColumnName = persister.getDiscriminatorColumnName()) != null && !"clazz_".equals(discrimColumnName);
    }

    public String getImportedClassName(String className) {
        return this.sfi.getImportedClassName(className);
    }

    public Queryable findQueryableUsingImports(String className) {
        return SessionFactoryHelper.findQueryableUsingImports(this.sfi, className);
    }

    public static Queryable findQueryableUsingImports(SessionFactoryImplementor sfi, String className) {
        String importedClassName = sfi.getImportedClassName(className);
        if (importedClassName == null) {
            return null;
        }
        try {
            return (Queryable)sfi.getEntityPersister(importedClassName);
        }
        catch (MappingException me) {
            return null;
        }
    }

    private EntityPersister findEntityPersisterByName(String name) throws MappingException {
        try {
            return this.sfi.getEntityPersister(name);
        }
        catch (MappingException ignore) {
            String importedClassName = this.sfi.getImportedClassName(name);
            if (importedClassName == null) {
                return null;
            }
            return this.sfi.getEntityPersister(importedClassName);
        }
    }

    public EntityPersister requireClassPersister(String name) throws SemanticException {
        EntityPersister cp;
        try {
            cp = this.findEntityPersisterByName(name);
            if (cp == null) {
                throw new QuerySyntaxException(name + " is not mapped");
            }
        }
        catch (MappingException e) {
            throw new DetailedSemanticException(e.getMessage(), e);
        }
        return cp;
    }

    public QueryableCollection getCollectionPersister(String role) {
        try {
            return (QueryableCollection)this.sfi.getCollectionPersister(role);
        }
        catch (ClassCastException cce) {
            throw new QueryException("collection is not queryable: " + role);
        }
        catch (Exception e) {
            throw new QueryException("collection not found: " + role);
        }
    }

    public QueryableCollection requireQueryableCollection(String role) throws QueryException {
        try {
            QueryableCollection queryableCollection = (QueryableCollection)this.sfi.getCollectionPersister(role);
            if (queryableCollection != null) {
                this.collectionPropertyMappingByRole.put(role, new CollectionPropertyMapping(queryableCollection));
            }
            return queryableCollection;
        }
        catch (ClassCastException cce) {
            throw new QueryException("collection role is not queryable: " + role);
        }
        catch (Exception e) {
            throw new QueryException("collection role not found: " + role);
        }
    }

    private PropertyMapping getCollectionPropertyMapping(String role) {
        return (PropertyMapping)this.collectionPropertyMappingByRole.get(role);
    }

    public String[] getCollectionElementColumns(String role, String roleAlias) {
        return this.getCollectionPropertyMapping(role).toColumns(roleAlias, "elements");
    }

    public JoinSequence createJoinSequence() {
        return new JoinSequence(this.sfi);
    }

    public JoinSequence createJoinSequence(boolean implicit, AssociationType associationType, String tableAlias, int joinType, String[] columns) {
        JoinSequence joinSequence = this.createJoinSequence();
        joinSequence.setUseThetaStyle(implicit);
        joinSequence.addJoin(associationType, tableAlias, joinType, columns);
        return joinSequence;
    }

    public JoinSequence createCollectionJoinSequence(QueryableCollection collPersister, String collectionName) {
        JoinSequence joinSequence = this.createJoinSequence();
        joinSequence.setRoot(collPersister, collectionName);
        joinSequence.setUseThetaStyle(true);
        return joinSequence;
    }

    public String getIdentifierOrUniqueKeyPropertyName(EntityType entityType) {
        try {
            return entityType.getIdentifierOrUniqueKeyPropertyName(this.sfi);
        }
        catch (MappingException me) {
            throw new QueryException(me);
        }
    }

    public int getColumnSpan(Type type) {
        return type.getColumnSpan(this.sfi);
    }

    public String getAssociatedEntityName(CollectionType collectionType) {
        return collectionType.getAssociatedEntityName(this.sfi);
    }

    private Type getElementType(CollectionType collectionType) {
        return collectionType.getElementType(this.sfi);
    }

    public AssociationType getElementAssociationType(CollectionType collectionType) {
        return (AssociationType)this.getElementType(collectionType);
    }

    public SQLFunction findSQLFunction(String functionName) {
        return this.sfi.getSqlFunctionRegistry().findSQLFunction(functionName.toLowerCase());
    }

    private SQLFunction requireSQLFunction(String functionName) {
        SQLFunction f = this.findSQLFunction(functionName);
        if (f == null) {
            throw new QueryException("Unable to find SQL function: " + functionName);
        }
        return f;
    }

    public Type findFunctionReturnType(String functionName, AST first) {
        Type argumentType = null;
        if ("cast".equals(functionName)) {
            argumentType = TypeFactory.heuristicType(first.getNextSibling().getText());
        } else if (first != null && first instanceof SqlNode) {
            argumentType = ((SqlNode)first).getDataType();
        }
        return this.requireSQLFunction(functionName).getReturnType(argumentType, this.sfi);
    }

    public String[][] generateColumnNames(Type[] sqlResultTypes) {
        return NameGenerator.generateColumnNames(sqlResultTypes, this.sfi);
    }

    public boolean isStrictJPAQLComplianceEnabled() {
        return this.sfi.getSettings().isStrictJPAQLCompliance();
    }
}

