/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.jdbc;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import javax.transaction.Synchronization;
import javax.transaction.TransactionManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.ConnectionReleaseMode;
import org.hibernate.HibernateException;
import org.hibernate.Interceptor;
import org.hibernate.SessionException;
import org.hibernate.Transaction;
import org.hibernate.TransactionException;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.exception.JDBCExceptionHelper;
import org.hibernate.jdbc.ConnectionManager;
import org.hibernate.transaction.CacheSynchronization;
import org.hibernate.transaction.TransactionFactory;
import org.hibernate.util.JTAHelper;

public class JDBCContext
implements Serializable,
ConnectionManager.Callback {
    private static final Log log = LogFactory.getLog((Class)JDBCContext.class);
    private Context owner;
    private ConnectionManager connectionManager;
    private transient boolean isTransactionCallbackRegistered;
    private transient Transaction hibernateTransaction;

    public JDBCContext(Context owner, Connection connection, Interceptor interceptor) {
        boolean registerSynchronization;
        this.owner = owner;
        this.connectionManager = new ConnectionManager(owner.getFactory(), this, owner.getConnectionReleaseMode(), connection, interceptor);
        boolean bl = registerSynchronization = owner.isAutoCloseSessionEnabled() || owner.isFlushBeforeCompletionEnabled() || owner.getConnectionReleaseMode() == ConnectionReleaseMode.AFTER_TRANSACTION;
        if (registerSynchronization) {
            this.registerSynchronizationIfPossible();
        }
    }

    private JDBCContext() {
    }

    public void connectionOpened() {
        if (this.owner.getFactory().getStatistics().isStatisticsEnabled()) {
            this.owner.getFactory().getStatisticsImplementor().connect();
        }
    }

    public void connectionCleanedUp() {
        if (!this.isTransactionCallbackRegistered) {
            this.afterTransactionCompletion(false, null);
        }
    }

    public SessionFactoryImplementor getFactory() {
        return this.owner.getFactory();
    }

    public ConnectionManager getConnectionManager() {
        return this.connectionManager;
    }

    public Connection borrowConnection() {
        return this.connectionManager.borrowConnection();
    }

    public Connection connection() throws HibernateException {
        if (this.owner.isClosed()) {
            throw new SessionException("Session is closed");
        }
        return this.connectionManager.getConnection();
    }

    public boolean registerCallbackIfNecessary() {
        if (this.isTransactionCallbackRegistered) {
            return false;
        }
        this.isTransactionCallbackRegistered = true;
        return true;
    }

    public boolean registerSynchronizationIfPossible() {
        if (this.isTransactionCallbackRegistered) {
            return true;
        }
        boolean localCallbacksOnly = this.owner.getFactory().getSettings().getTransactionFactory().areCallbacksLocalToHibernateTransactions();
        if (localCallbacksOnly) {
            return false;
        }
        TransactionManager tm = this.owner.getFactory().getTransactionManager();
        if (tm == null) {
            return false;
        }
        try {
            if (!this.isTransactionInProgress()) {
                log.debug((Object)"TransactionFactory reported no active transaction; Synchronization not registered");
                return false;
            }
            javax.transaction.Transaction tx = tm.getTransaction();
            if (JTAHelper.isMarkedForRollback(tx)) {
                log.debug((Object)"Transaction is marked for rollback; skipping Synchronization registration");
                return false;
            }
            tx.registerSynchronization((Synchronization)new CacheSynchronization(this.owner, this, tx, null));
            this.isTransactionCallbackRegistered = true;
            log.debug((Object)"successfully registered Synchronization");
            return true;
        }
        catch (HibernateException e) {
            throw e;
        }
        catch (Exception e) {
            throw new TransactionException("could not register synchronization with JTA TransactionManager", e);
        }
    }

    public boolean isTransactionInProgress() {
        return this.owner.getFactory().getSettings().getTransactionFactory().isTransactionInProgress(this, this.owner, this.hibernateTransaction);
    }

    public Transaction getTransaction() throws HibernateException {
        if (this.hibernateTransaction == null) {
            this.hibernateTransaction = this.owner.getFactory().getSettings().getTransactionFactory().createTransaction(this, this.owner);
        }
        return this.hibernateTransaction;
    }

    public void beforeTransactionCompletion(Transaction tx) {
        log.trace((Object)"before transaction completion");
        this.owner.beforeTransactionCompletion(tx);
    }

    public void afterTransactionBegin(Transaction tx) {
        log.trace((Object)"after transaction begin");
        this.owner.afterTransactionBegin(tx);
    }

    public void afterTransactionCompletion(boolean success, Transaction tx) {
        log.trace((Object)"after transaction completion");
        if (this.getFactory().getStatistics().isStatisticsEnabled()) {
            this.getFactory().getStatisticsImplementor().endTransaction(success);
        }
        this.connectionManager.afterTransaction();
        this.isTransactionCallbackRegistered = false;
        this.hibernateTransaction = null;
        this.owner.afterTransactionCompletion(success, tx);
    }

    public void afterNontransactionalQuery(boolean success) {
        log.trace((Object)"after autocommit");
        try {
            boolean isAutocommit = this.connectionManager.isAutoCommit();
            this.connectionManager.afterTransaction();
            if (isAutocommit) {
                this.owner.afterTransactionCompletion(success, null);
            }
        }
        catch (SQLException sqle) {
            throw JDBCExceptionHelper.convert(this.owner.getFactory().getSQLExceptionConverter(), sqle, "could not inspect JDBC autocommit mode");
        }
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        oos.defaultWriteObject();
        boolean deserHasCallbackRegistered = this.isTransactionCallbackRegistered && !this.owner.getFactory().getSettings().getTransactionFactory().areCallbacksLocalToHibernateTransactions();
        oos.writeBoolean(deserHasCallbackRegistered);
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        ois.defaultReadObject();
        this.isTransactionCallbackRegistered = ois.readBoolean();
    }

    public void serialize(ObjectOutputStream oos) throws IOException {
        this.connectionManager.serialize(oos);
    }

    public static JDBCContext deserialize(ObjectInputStream ois, Context context, Interceptor interceptor) throws IOException {
        JDBCContext jdbcContext = new JDBCContext();
        jdbcContext.owner = context;
        jdbcContext.connectionManager = ConnectionManager.deserialize(ois, context.getFactory(), interceptor, context.getConnectionReleaseMode(), jdbcContext);
        return jdbcContext;
    }

    public static interface Context
    extends TransactionFactory.Context {
        public void afterTransactionBegin(Transaction var1);

        public void beforeTransactionCompletion(Transaction var1);

        public void afterTransactionCompletion(boolean var1, Transaction var2);

        public ConnectionReleaseMode getConnectionReleaseMode();

        public boolean isAutoCloseSessionEnabled();
    }
}

