/*
 * Decompiled with CFR 0.152.
 */
package com.ibatis.common.beans;

import com.ibatis.common.beans.ProbeException;
import com.ibatis.common.logging.Log;
import com.ibatis.common.logging.LogFactory;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ReflectPermission;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class ClassInfo {
    private static final Log log = LogFactory.getLog(class$com$ibatis$common$beans$ClassInfo == null ? (class$com$ibatis$common$beans$ClassInfo = ClassInfo.class$("com.ibatis.common.beans.ClassInfo")) : class$com$ibatis$common$beans$ClassInfo);
    private static boolean cacheEnabled = true;
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private static final Set SIMPLE_TYPE_SET = new HashSet();
    private static final Map CLASS_INFO_MAP = Collections.synchronizedMap(new HashMap());
    private String className;
    private String[] readablePropertyNames = EMPTY_STRING_ARRAY;
    private String[] writeablePropertyNames = EMPTY_STRING_ARRAY;
    private HashMap setMethods = new HashMap();
    private HashMap getMethods = new HashMap();
    private HashMap setTypes = new HashMap();
    private HashMap getTypes = new HashMap();
    static /* synthetic */ Class class$com$ibatis$common$beans$ClassInfo;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$util$Date;
    static /* synthetic */ Class class$java$lang$Class;
    static /* synthetic */ Class class$java$math$BigInteger;
    static /* synthetic */ Class class$java$math$BigDecimal;
    static /* synthetic */ Class class$java$util$Collection;
    static /* synthetic */ Class class$java$util$Set;
    static /* synthetic */ Class class$java$util$Map;
    static /* synthetic */ Class class$java$util$List;
    static /* synthetic */ Class class$java$util$HashMap;
    static /* synthetic */ Class class$java$util$TreeMap;
    static /* synthetic */ Class class$java$util$ArrayList;
    static /* synthetic */ Class class$java$util$LinkedList;
    static /* synthetic */ Class class$java$util$HashSet;
    static /* synthetic */ Class class$java$util$TreeSet;
    static /* synthetic */ Class class$java$util$Vector;
    static /* synthetic */ Class class$java$util$Hashtable;
    static /* synthetic */ Class class$java$util$Enumeration;
    static /* synthetic */ Class class$java$util$Iterator;

    private ClassInfo(Class clazz) {
        this.className = clazz.getName();
        this.addMethods(clazz);
        this.readablePropertyNames = this.getMethods.keySet().toArray(new String[this.getMethods.keySet().size()]);
        this.writeablePropertyNames = this.setMethods.keySet().toArray(new String[this.setMethods.keySet().size()]);
    }

    private void addMethods(Class cls) {
        Method[] methods = this.getAllMethodsForClass(cls);
        for (int i = 0; i < methods.length; ++i) {
            String name = methods[i].getName();
            if (name.startsWith("set") && name.length() > 3) {
                if (methods[i].getParameterTypes().length == 1) {
                    if (this.setMethods.containsKey(name = ClassInfo.dropCase(name))) {
                        log.error("Illegal overloaded setter method for property " + name + " in class " + cls.getName() + ".  This breaks the JavaBeans specification and can cause unpredicatble results.");
                    }
                    this.setMethods.put(name, methods[i]);
                    this.setTypes.put(name, methods[i].getParameterTypes()[0]);
                }
            } else if (name.startsWith("get") && name.length() > 3) {
                if (methods[i].getParameterTypes().length == 0) {
                    name = ClassInfo.dropCase(name);
                    this.getMethods.put(name, methods[i]);
                    this.getTypes.put(name, methods[i].getReturnType());
                }
            } else if (name.startsWith("is") && name.length() > 2 && methods[i].getParameterTypes().length == 0) {
                name = ClassInfo.dropCase(name);
                this.getMethods.put(name, methods[i]);
                this.getTypes.put(name, methods[i].getReturnType());
            }
            name = null;
        }
    }

    private Method[] getAllMethodsForClass(Class cls) {
        HashSet uniqueMethodNames = new HashSet();
        ArrayList allMethods = new ArrayList();
        for (Class currentClass = cls; currentClass != null; currentClass = currentClass.getSuperclass()) {
            this.addMethods(currentClass, uniqueMethodNames, allMethods);
            Class<?>[] interfaces = currentClass.getInterfaces();
            for (int i = 0; i < interfaces.length; ++i) {
                this.addMethods(interfaces[i], uniqueMethodNames, allMethods);
            }
        }
        return allMethods.toArray(new Method[allMethods.size()]);
    }

    private void addMethods(Class currentClass, Set uniqueMethodNames, List allMethods) {
        Method[] methods = currentClass.getDeclaredMethods();
        for (int i = 0; i < methods.length; ++i) {
            Method currentMethod = methods[i];
            String methodName = currentMethod.getName() + currentMethod.getParameterTypes().length;
            if (uniqueMethodNames.contains(methodName)) continue;
            uniqueMethodNames.add(methodName);
            if (this.canAccessPrivateMethods()) {
                try {
                    currentMethod.setAccessible(true);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            allMethods.add(currentMethod);
        }
    }

    private boolean canAccessPrivateMethods() {
        try {
            System.getSecurityManager().checkPermission(new ReflectPermission("suppressAccessChecks"));
            return true;
        }
        catch (SecurityException e) {
            return false;
        }
        catch (NullPointerException e) {
            return true;
        }
    }

    private static String dropCase(String name) {
        if (name.startsWith("is")) {
            name = name.substring(2);
        } else if (name.startsWith("get") || name.startsWith("set")) {
            name = name.substring(3);
        } else {
            throw new ProbeException("Error parsing property name '" + name + "'.  Didn't start with 'is', 'get' or 'set'.");
        }
        if (name.length() == 1 || name.length() > 1 && !Character.isUpperCase(name.charAt(1))) {
            name = name.substring(0, 1).toLowerCase(Locale.US) + name.substring(1);
        }
        return name;
    }

    public String getClassName() {
        return this.className;
    }

    public Method getSetter(String propertyName) {
        Method method = (Method)this.setMethods.get(propertyName);
        if (method == null) {
            throw new ProbeException("There is no WRITEABLE property named '" + propertyName + "' in class '" + this.className + "'");
        }
        return method;
    }

    public Method getGetter(String propertyName) {
        Method method = (Method)this.getMethods.get(propertyName);
        if (method == null) {
            throw new ProbeException("There is no READABLE property named '" + propertyName + "' in class '" + this.className + "'");
        }
        return method;
    }

    public Class getSetterType(String propertyName) {
        Class clazz = (Class)this.setTypes.get(propertyName);
        if (clazz == null) {
            throw new ProbeException("There is no WRITEABLE property named '" + propertyName + "' in class '" + this.className + "'");
        }
        return clazz;
    }

    public Class getGetterType(String propertyName) {
        Class clazz = (Class)this.getTypes.get(propertyName);
        if (clazz == null) {
            throw new ProbeException("There is no READABLE property named '" + propertyName + "' in class '" + this.className + "'");
        }
        return clazz;
    }

    public String[] getReadablePropertyNames() {
        return this.readablePropertyNames;
    }

    public String[] getWriteablePropertyNames() {
        return this.writeablePropertyNames;
    }

    public boolean hasWritableProperty(String propertyName) {
        return this.setMethods.keySet().contains(propertyName);
    }

    public boolean hasReadableProperty(String propertyName) {
        return this.getMethods.keySet().contains(propertyName);
    }

    public static boolean isKnownType(Class clazz) {
        if (SIMPLE_TYPE_SET.contains(clazz)) {
            return true;
        }
        if ((class$java$util$Collection == null ? (class$java$util$Collection = ClassInfo.class$("java.util.Collection")) : class$java$util$Collection).isAssignableFrom(clazz)) {
            return true;
        }
        if ((class$java$util$Map == null ? (class$java$util$Map = ClassInfo.class$("java.util.Map")) : class$java$util$Map).isAssignableFrom(clazz)) {
            return true;
        }
        if ((class$java$util$List == null ? (class$java$util$List = ClassInfo.class$("java.util.List")) : class$java$util$List).isAssignableFrom(clazz)) {
            return true;
        }
        if ((class$java$util$Set == null ? (class$java$util$Set = ClassInfo.class$("java.util.Set")) : class$java$util$Set).isAssignableFrom(clazz)) {
            return true;
        }
        return (class$java$util$Iterator == null ? (class$java$util$Iterator = ClassInfo.class$("java.util.Iterator")) : class$java$util$Iterator).isAssignableFrom(clazz);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ClassInfo getInstance(Class clazz) {
        if (cacheEnabled) {
            Class clazz2 = clazz;
            synchronized (clazz2) {
                ClassInfo cache = (ClassInfo)CLASS_INFO_MAP.get(clazz);
                if (cache == null) {
                    cache = new ClassInfo(clazz);
                    CLASS_INFO_MAP.put(clazz, cache);
                }
                return cache;
            }
        }
        return new ClassInfo(clazz);
    }

    public static void setCacheEnabled(boolean cacheEnabled) {
        ClassInfo.cacheEnabled = cacheEnabled;
    }

    public static Throwable unwrapThrowable(Throwable t) {
        Throwable t2 = t;
        while (true) {
            if (t2 instanceof InvocationTargetException) {
                t2 = ((InvocationTargetException)t).getTargetException();
                continue;
            }
            if (!(t instanceof UndeclaredThrowableException)) break;
            t2 = ((UndeclaredThrowableException)t).getUndeclaredThrowable();
        }
        return t2;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        SIMPLE_TYPE_SET.add(class$java$lang$String == null ? (class$java$lang$String = ClassInfo.class$("java.lang.String")) : class$java$lang$String);
        SIMPLE_TYPE_SET.add(class$java$lang$Byte == null ? (class$java$lang$Byte = ClassInfo.class$("java.lang.Byte")) : class$java$lang$Byte);
        SIMPLE_TYPE_SET.add(class$java$lang$Short == null ? (class$java$lang$Short = ClassInfo.class$("java.lang.Short")) : class$java$lang$Short);
        SIMPLE_TYPE_SET.add(class$java$lang$Character == null ? (class$java$lang$Character = ClassInfo.class$("java.lang.Character")) : class$java$lang$Character);
        SIMPLE_TYPE_SET.add(class$java$lang$Integer == null ? (class$java$lang$Integer = ClassInfo.class$("java.lang.Integer")) : class$java$lang$Integer);
        SIMPLE_TYPE_SET.add(class$java$lang$Long == null ? (class$java$lang$Long = ClassInfo.class$("java.lang.Long")) : class$java$lang$Long);
        SIMPLE_TYPE_SET.add(class$java$lang$Float == null ? (class$java$lang$Float = ClassInfo.class$("java.lang.Float")) : class$java$lang$Float);
        SIMPLE_TYPE_SET.add(class$java$lang$Double == null ? (class$java$lang$Double = ClassInfo.class$("java.lang.Double")) : class$java$lang$Double);
        SIMPLE_TYPE_SET.add(class$java$lang$Boolean == null ? (class$java$lang$Boolean = ClassInfo.class$("java.lang.Boolean")) : class$java$lang$Boolean);
        SIMPLE_TYPE_SET.add(class$java$util$Date == null ? (class$java$util$Date = ClassInfo.class$("java.util.Date")) : class$java$util$Date);
        SIMPLE_TYPE_SET.add(class$java$lang$Class == null ? (class$java$lang$Class = ClassInfo.class$("java.lang.Class")) : class$java$lang$Class);
        SIMPLE_TYPE_SET.add(class$java$math$BigInteger == null ? (class$java$math$BigInteger = ClassInfo.class$("java.math.BigInteger")) : class$java$math$BigInteger);
        SIMPLE_TYPE_SET.add(class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = ClassInfo.class$("java.math.BigDecimal")) : class$java$math$BigDecimal);
        SIMPLE_TYPE_SET.add(class$java$util$Collection == null ? (class$java$util$Collection = ClassInfo.class$("java.util.Collection")) : class$java$util$Collection);
        SIMPLE_TYPE_SET.add(class$java$util$Set == null ? (class$java$util$Set = ClassInfo.class$("java.util.Set")) : class$java$util$Set);
        SIMPLE_TYPE_SET.add(class$java$util$Map == null ? (class$java$util$Map = ClassInfo.class$("java.util.Map")) : class$java$util$Map);
        SIMPLE_TYPE_SET.add(class$java$util$List == null ? (class$java$util$List = ClassInfo.class$("java.util.List")) : class$java$util$List);
        SIMPLE_TYPE_SET.add(class$java$util$HashMap == null ? (class$java$util$HashMap = ClassInfo.class$("java.util.HashMap")) : class$java$util$HashMap);
        SIMPLE_TYPE_SET.add(class$java$util$TreeMap == null ? (class$java$util$TreeMap = ClassInfo.class$("java.util.TreeMap")) : class$java$util$TreeMap);
        SIMPLE_TYPE_SET.add(class$java$util$ArrayList == null ? (class$java$util$ArrayList = ClassInfo.class$("java.util.ArrayList")) : class$java$util$ArrayList);
        SIMPLE_TYPE_SET.add(class$java$util$LinkedList == null ? (class$java$util$LinkedList = ClassInfo.class$("java.util.LinkedList")) : class$java$util$LinkedList);
        SIMPLE_TYPE_SET.add(class$java$util$HashSet == null ? (class$java$util$HashSet = ClassInfo.class$("java.util.HashSet")) : class$java$util$HashSet);
        SIMPLE_TYPE_SET.add(class$java$util$TreeSet == null ? (class$java$util$TreeSet = ClassInfo.class$("java.util.TreeSet")) : class$java$util$TreeSet);
        SIMPLE_TYPE_SET.add(class$java$util$Vector == null ? (class$java$util$Vector = ClassInfo.class$("java.util.Vector")) : class$java$util$Vector);
        SIMPLE_TYPE_SET.add(class$java$util$Hashtable == null ? (class$java$util$Hashtable = ClassInfo.class$("java.util.Hashtable")) : class$java$util$Hashtable);
        SIMPLE_TYPE_SET.add(class$java$util$Enumeration == null ? (class$java$util$Enumeration = ClassInfo.class$("java.util.Enumeration")) : class$java$util$Enumeration);
    }
}

