/*
 * Decompiled with CFR 0.152.
 */
package com.ibatis.sqlmap.engine.execution;

import com.ibatis.sqlmap.engine.execution.BatchException;
import com.ibatis.sqlmap.engine.execution.BatchResult;
import com.ibatis.sqlmap.engine.impl.ExtendedSqlMapClient;
import com.ibatis.sqlmap.engine.mapping.parameter.BasicParameterMapping;
import com.ibatis.sqlmap.engine.mapping.parameter.ParameterMap;
import com.ibatis.sqlmap.engine.mapping.parameter.ParameterMapping;
import com.ibatis.sqlmap.engine.mapping.result.ResultMap;
import com.ibatis.sqlmap.engine.mapping.statement.DefaultRowHandler;
import com.ibatis.sqlmap.engine.mapping.statement.MappedStatement;
import com.ibatis.sqlmap.engine.mapping.statement.RowHandlerCallback;
import com.ibatis.sqlmap.engine.scope.ErrorContext;
import com.ibatis.sqlmap.engine.scope.RequestScope;
import com.ibatis.sqlmap.engine.scope.SessionScope;
import java.sql.BatchUpdateException;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;

public class SqlExecutor {
    public static final int NO_SKIPPED_RESULTS = 0;
    public static final int NO_MAXIMUM_RESULTS = -999999;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int executeUpdate(RequestScope request, Connection conn, String sql, Object[] parameters) throws SQLException {
        ErrorContext errorContext = request.getErrorContext();
        errorContext.setActivity("executing update");
        errorContext.setObjectId(sql);
        PreparedStatement ps = null;
        int rows = 0;
        try {
            errorContext.setMoreInfo("Check the SQL Statement (preparation failed).");
            ps = conn.prepareStatement(sql);
            SqlExecutor.setStatementTimeout(request.getStatement(), ps);
            errorContext.setMoreInfo("Check the parameters (set parameters failed).");
            request.getParameterMap().setParameters(request, ps, parameters);
            errorContext.setMoreInfo("Check the statement (update failed).");
            ps.execute();
            rows = ps.getUpdateCount();
        }
        catch (Throwable throwable) {
            SqlExecutor.closeStatement(ps);
            throw throwable;
        }
        SqlExecutor.closeStatement(ps);
        return rows;
    }

    public void addBatch(RequestScope request, Connection conn, String sql, Object[] parameters) throws SQLException {
        Batch batch = (Batch)request.getSession().getBatch();
        if (batch == null) {
            batch = new Batch();
            request.getSession().setBatch(batch);
        }
        batch.addBatch(request, conn, sql, parameters);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int executeBatch(SessionScope session) throws SQLException {
        int rows = 0;
        Batch batch = (Batch)session.getBatch();
        if (batch != null) {
            try {
                rows = batch.executeBatch();
            }
            finally {
                batch.cleanupBatch();
            }
        }
        return rows;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List executeBatchDetailed(SessionScope session) throws SQLException, BatchException {
        List answer = null;
        Batch batch = (Batch)session.getBatch();
        if (batch != null) {
            try {
                answer = batch.executeBatchDetailed();
            }
            finally {
                batch.cleanupBatch();
            }
        }
        return answer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeQuery(RequestScope request, Connection conn, String sql, Object[] parameters, int skipResults, int maxResults, RowHandlerCallback callback) throws SQLException {
        ErrorContext errorContext = request.getErrorContext();
        errorContext.setActivity("executing query");
        errorContext.setObjectId(sql);
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            errorContext.setMoreInfo("Check the SQL Statement (preparation failed).");
            Integer rsType = request.getStatement().getResultSetType();
            ps = rsType != null ? conn.prepareStatement(sql, rsType, 1007) : conn.prepareStatement(sql);
            SqlExecutor.setStatementTimeout(request.getStatement(), ps);
            Integer fetchSize = request.getStatement().getFetchSize();
            if (fetchSize != null) {
                ps.setFetchSize(fetchSize);
            }
            errorContext.setMoreInfo("Check the parameters (set parameters failed).");
            request.getParameterMap().setParameters(request, ps, parameters);
            errorContext.setMoreInfo("Check the statement (query failed).");
            ps.execute();
            errorContext.setMoreInfo("Check the results (failed to retrieve results).");
            rs = this.handleMultipleResults(ps, request, skipResults, maxResults, callback);
            Object var14_13 = null;
        }
        catch (Throwable throwable) {
            Object var14_14 = null;
            try {
                SqlExecutor.closeResultSet(rs);
            }
            finally {
                SqlExecutor.closeStatement(ps);
            }
            throw throwable;
        }
        try {
            SqlExecutor.closeResultSet(rs);
        }
        finally {
            SqlExecutor.closeStatement(ps);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int executeUpdateProcedure(RequestScope request, Connection conn, String sql, Object[] parameters) throws SQLException {
        ErrorContext errorContext = request.getErrorContext();
        errorContext.setActivity("executing update procedure");
        errorContext.setObjectId(sql);
        CallableStatement cs = null;
        int rows = 0;
        try {
            errorContext.setMoreInfo("Check the SQL Statement (preparation failed).");
            cs = conn.prepareCall(sql);
            SqlExecutor.setStatementTimeout(request.getStatement(), cs);
            ParameterMap parameterMap = request.getParameterMap();
            ParameterMapping[] mappings = parameterMap.getParameterMappings();
            errorContext.setMoreInfo("Check the output parameters (register output parameters failed).");
            this.registerOutputParameters(cs, mappings);
            errorContext.setMoreInfo("Check the parameters (set parameters failed).");
            parameterMap.setParameters(request, cs, parameters);
            errorContext.setMoreInfo("Check the statement (update procedure failed).");
            cs.execute();
            rows = cs.getUpdateCount();
            errorContext.setMoreInfo("Check the output parameters (retrieval of output parameters failed).");
            this.retrieveOutputParameters(request, cs, mappings, parameters, null);
        }
        catch (Throwable throwable) {
            SqlExecutor.closeStatement(cs);
            throw throwable;
        }
        SqlExecutor.closeStatement(cs);
        return rows;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeQueryProcedure(RequestScope request, Connection conn, String sql, Object[] parameters, int skipResults, int maxResults, RowHandlerCallback callback) throws SQLException {
        ErrorContext errorContext = request.getErrorContext();
        errorContext.setActivity("executing query procedure");
        errorContext.setObjectId(sql);
        CallableStatement cs = null;
        ResultSet rs = null;
        try {
            errorContext.setMoreInfo("Check the SQL Statement (preparation failed).");
            Integer rsType = request.getStatement().getResultSetType();
            cs = rsType != null ? conn.prepareCall(sql, rsType, 1007) : conn.prepareCall(sql);
            SqlExecutor.setStatementTimeout(request.getStatement(), cs);
            Integer fetchSize = request.getStatement().getFetchSize();
            if (fetchSize != null) {
                cs.setFetchSize(fetchSize);
            }
            ParameterMap parameterMap = request.getParameterMap();
            ParameterMapping[] mappings = parameterMap.getParameterMappings();
            errorContext.setMoreInfo("Check the output parameters (register output parameters failed).");
            this.registerOutputParameters(cs, mappings);
            errorContext.setMoreInfo("Check the parameters (set parameters failed).");
            parameterMap.setParameters(request, cs, parameters);
            errorContext.setMoreInfo("Check the statement (update procedure failed).");
            cs.execute();
            errorContext.setMoreInfo("Check the results (failed to retrieve results).");
            rs = this.handleMultipleResults(cs, request, skipResults, maxResults, callback);
            errorContext.setMoreInfo("Check the output parameters (retrieval of output parameters failed).");
            this.retrieveOutputParameters(request, cs, mappings, parameters, callback);
            Object var16_15 = null;
        }
        catch (Throwable throwable) {
            Object var16_16 = null;
            try {
                SqlExecutor.closeResultSet(rs);
            }
            finally {
                SqlExecutor.closeStatement(cs);
            }
            throw throwable;
        }
        try {
            SqlExecutor.closeResultSet(rs);
        }
        finally {
            SqlExecutor.closeStatement(cs);
        }
    }

    private ResultSet handleMultipleResults(PreparedStatement ps, RequestScope request, int skipResults, int maxResults, RowHandlerCallback callback) throws SQLException {
        ResultSet rs = this.getFirstResultSet(ps);
        if (rs != null) {
            this.handleResults(request, rs, skipResults, maxResults, callback);
        }
        if (callback.getRowHandler() instanceof DefaultRowHandler) {
            MappedStatement statement = request.getStatement();
            DefaultRowHandler defaultRowHandler = (DefaultRowHandler)callback.getRowHandler();
            if (statement.hasMultipleResultMaps()) {
                ArrayList<List> multipleResults = new ArrayList<List>();
                multipleResults.add(defaultRowHandler.getList());
                ResultMap[] resultMaps = statement.getAdditionalResultMaps();
                for (int i = 0; this.moveToNextResultsSafely(ps) && i < resultMaps.length; ++i) {
                    ResultMap rm = resultMaps[i];
                    request.setResultMap(rm);
                    rs = ps.getResultSet();
                    DefaultRowHandler rh = new DefaultRowHandler();
                    this.handleResults(request, rs, skipResults, maxResults, new RowHandlerCallback(rm, null, rh));
                    multipleResults.add(rh.getList());
                }
                defaultRowHandler.setList(multipleResults);
                request.setResultMap(statement.getResultMap());
            } else {
                while (this.moveToNextResultsSafely(ps)) {
                }
            }
        }
        return rs;
    }

    private ResultSet getFirstResultSet(Statement stmt) throws SQLException {
        ResultSet rs = null;
        boolean hasMoreResults = true;
        while (hasMoreResults && (rs = stmt.getResultSet()) == null) {
            hasMoreResults = this.moveToNextResultsIfPresent(stmt);
        }
        return rs;
    }

    private boolean moveToNextResultsIfPresent(Statement stmt) throws SQLException {
        boolean moreResults = this.moveToNextResultsSafely(stmt) || stmt.getUpdateCount() != -1;
        return moreResults;
    }

    private boolean moveToNextResultsSafely(Statement stmt) throws SQLException {
        if (!stmt.getConnection().getMetaData().supportsMultipleResultSets()) {
            return false;
        }
        return stmt.getMoreResults();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleResults(RequestScope request, ResultSet rs, int skipResults, int maxResults, RowHandlerCallback callback) throws SQLException {
        try {
            request.setResultSet(rs);
            ResultMap resultMap = request.getResultMap();
            if (resultMap != null) {
                if (rs.getType() != 1003) {
                    if (skipResults > 0) {
                        rs.absolute(skipResults);
                    }
                } else {
                    for (int i = 0; i < skipResults; ++i) {
                        if (rs.next()) continue;
                        return;
                    }
                }
                for (int resultsFetched = 0; (maxResults == -999999 || resultsFetched < maxResults) && rs.next(); ++resultsFetched) {
                    Object[] columnValues = resultMap.resolveSubMap(request, rs).getResults(request, rs);
                    callback.handleResultObject(request, columnValues, rs);
                }
            }
        }
        finally {
            request.setResultSet(null);
        }
    }

    private void retrieveOutputParameters(RequestScope request, CallableStatement cs, ParameterMapping[] mappings, Object[] parameters, RowHandlerCallback callback) throws SQLException {
        for (int i = 0; i < mappings.length; ++i) {
            BasicParameterMapping mapping = (BasicParameterMapping)mappings[i];
            if (!mapping.isOutputAllowed()) continue;
            if ("java.sql.ResultSet".equalsIgnoreCase(mapping.getJavaTypeName())) {
                ResultMap resultMap;
                ResultSet rs = (ResultSet)cs.getObject(i + 1);
                if (mapping.getResultMapName() == null) {
                    resultMap = request.getResultMap();
                    this.handleOutputParameterResults(request, resultMap, rs, callback);
                } else {
                    ExtendedSqlMapClient client = (ExtendedSqlMapClient)request.getSession().getSqlMapClient();
                    resultMap = client.getDelegate().getResultMap(mapping.getResultMapName());
                    DefaultRowHandler rowHandler = new DefaultRowHandler();
                    RowHandlerCallback handlerCallback = new RowHandlerCallback(resultMap, null, rowHandler);
                    this.handleOutputParameterResults(request, resultMap, rs, handlerCallback);
                    parameters[i] = rowHandler.getList();
                }
                rs.close();
                continue;
            }
            parameters[i] = mapping.getTypeHandler().getResult(cs, i + 1);
        }
    }

    private void registerOutputParameters(CallableStatement cs, ParameterMapping[] mappings) throws SQLException {
        for (int i = 0; i < mappings.length; ++i) {
            BasicParameterMapping mapping = (BasicParameterMapping)mappings[i];
            if (!mapping.isOutputAllowed()) continue;
            if (null != mapping.getTypeName() && !mapping.getTypeName().equals("")) {
                cs.registerOutParameter(i + 1, mapping.getJdbcType(), mapping.getTypeName());
                continue;
            }
            if (mapping.getNumericScale() != null && (mapping.getJdbcType() == 2 || mapping.getJdbcType() == 3)) {
                cs.registerOutParameter(i + 1, mapping.getJdbcType(), (int)mapping.getNumericScale());
                continue;
            }
            cs.registerOutParameter(i + 1, mapping.getJdbcType());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleOutputParameterResults(RequestScope request, ResultMap resultMap, ResultSet rs, RowHandlerCallback callback) throws SQLException {
        ResultMap orig = request.getResultMap();
        try {
            request.setResultSet(rs);
            if (resultMap != null) {
                request.setResultMap(resultMap);
                while (rs.next()) {
                    Object[] columnValues = resultMap.resolveSubMap(request, rs).getResults(request, rs);
                    callback.handleResultObject(request, columnValues, rs);
                }
            }
        }
        finally {
            request.setResultSet(null);
            request.setResultMap(orig);
        }
    }

    public void cleanup(SessionScope session) {
        Batch batch = (Batch)session.getBatch();
        if (batch != null) {
            batch.cleanupBatch();
            session.setBatch(null);
        }
    }

    private static void closeStatement(PreparedStatement ps) {
        if (ps != null) {
            try {
                ps.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    private static void closeResultSet(ResultSet rs) {
        if (rs != null) {
            try {
                rs.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    private static void setStatementTimeout(MappedStatement mappedStatement, Statement statement) throws SQLException {
        if (mappedStatement.getTimeout() != null) {
            statement.setQueryTimeout(mappedStatement.getTimeout());
        } else {
            statement.setQueryTimeout(0);
        }
    }

    private static class Batch {
        private String currentSql;
        private List statementList = new ArrayList();
        private List batchResultList = new ArrayList();
        private int size = 0;

        public int getSize() {
            return this.size;
        }

        public void addBatch(RequestScope request, Connection conn, String sql, Object[] parameters) throws SQLException {
            PreparedStatement ps = null;
            if (this.currentSql != null && sql.hashCode() == this.currentSql.hashCode() && sql.length() == this.currentSql.length()) {
                int last = this.statementList.size() - 1;
                ps = (PreparedStatement)this.statementList.get(last);
            } else {
                ps = conn.prepareStatement(sql);
                SqlExecutor.setStatementTimeout(request.getStatement(), ps);
                this.currentSql = sql;
                this.statementList.add(ps);
                this.batchResultList.add(new BatchResult(request.getStatement().getId(), sql));
            }
            request.getParameterMap().setParameters(request, ps, parameters);
            ps.addBatch();
            ++this.size;
        }

        public int executeBatch() throws SQLException {
            int totalRowCount = 0;
            int n = this.statementList.size();
            for (int i = 0; i < n; ++i) {
                PreparedStatement ps = (PreparedStatement)this.statementList.get(i);
                int[] rowCounts = ps.executeBatch();
                for (int j = 0; j < rowCounts.length; ++j) {
                    if (rowCounts[j] == -2) continue;
                    if (rowCounts[j] == -3) {
                        throw new SQLException("The batched statement at index " + j + " failed to execute.");
                    }
                    totalRowCount += rowCounts[j];
                }
            }
            return totalRowCount;
        }

        public List executeBatchDetailed() throws SQLException, BatchException {
            ArrayList<BatchResult> answer = new ArrayList<BatchResult>();
            int n = this.statementList.size();
            for (int i = 0; i < n; ++i) {
                BatchResult br = (BatchResult)this.batchResultList.get(i);
                PreparedStatement ps = (PreparedStatement)this.statementList.get(i);
                try {
                    br.setUpdateCounts(ps.executeBatch());
                }
                catch (BatchUpdateException e) {
                    StringBuffer message = new StringBuffer();
                    message.append("Sub batch number ");
                    message.append(i + 1);
                    message.append(" failed.");
                    if (i > 0) {
                        message.append(" ");
                        message.append(i);
                        message.append(" prior sub batch(s) completed successfully, but will be rolled back.");
                    }
                    throw new BatchException(message.toString(), e, answer, br.getStatementId(), br.getSql());
                }
                answer.add(br);
            }
            return answer;
        }

        public void cleanupBatch() {
            int n = this.statementList.size();
            for (int i = 0; i < n; ++i) {
                PreparedStatement ps = (PreparedStatement)this.statementList.get(i);
                SqlExecutor.closeStatement(ps);
            }
            this.currentSql = null;
            this.statementList.clear();
            this.batchResultList.clear();
            this.size = 0;
        }
    }
}

