/*
 * Decompiled with CFR 0.152.
 */
package com.ibatis.sqlmap.engine.mapping.result;

import com.ibatis.common.beans.Probe;
import com.ibatis.common.beans.ProbeFactory;
import com.ibatis.common.jdbc.exception.NestedSQLException;
import com.ibatis.sqlmap.client.SqlMapException;
import com.ibatis.sqlmap.engine.exchange.DataExchange;
import com.ibatis.sqlmap.engine.impl.ExtendedSqlMapClient;
import com.ibatis.sqlmap.engine.impl.SqlMapExecutorDelegate;
import com.ibatis.sqlmap.engine.mapping.result.BasicResultMapping;
import com.ibatis.sqlmap.engine.mapping.result.Discriminator;
import com.ibatis.sqlmap.engine.mapping.result.ResultMap;
import com.ibatis.sqlmap.engine.mapping.result.ResultMapping;
import com.ibatis.sqlmap.engine.mapping.result.ResultObjectFactoryUtil;
import com.ibatis.sqlmap.engine.mapping.result.loader.ResultLoader;
import com.ibatis.sqlmap.engine.mapping.sql.Sql;
import com.ibatis.sqlmap.engine.mapping.statement.MappedStatement;
import com.ibatis.sqlmap.engine.scope.ErrorContext;
import com.ibatis.sqlmap.engine.scope.RequestScope;
import com.ibatis.sqlmap.engine.type.TypeHandler;
import com.ibatis.sqlmap.engine.type.TypeHandlerFactory;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;

public class BasicResultMap
implements ResultMap {
    private static final Probe PROBE = ProbeFactory.getProbe();
    private static final String KEY_SEPARATOR = "\u0002";
    private String id;
    private Class resultClass;
    private ResultMapping[] resultMappings;
    private ThreadLocal remappableResultMappings = new ThreadLocal();
    private DataExchange dataExchange;
    private List nestedResultMappings;
    private Discriminator discriminator;
    private Set groupByProps;
    private String xmlName;
    private String resource;
    private SqlMapExecutorDelegate delegate;
    protected boolean allowRemapping = false;
    static /* synthetic */ Class class$java$util$Map;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$com$ibatis$sqlmap$engine$type$DomTypeMarker;
    static /* synthetic */ Class class$java$util$Collection;
    static /* synthetic */ Class class$com$ibatis$sqlmap$engine$type$DomCollectionTypeMarker;
    static /* synthetic */ Class class$java$lang$String;

    public BasicResultMap(SqlMapExecutorDelegate delegate) {
        this.delegate = delegate;
    }

    public SqlMapExecutorDelegate getDelegate() {
        return this.delegate;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Class getResultClass() {
        return this.resultClass;
    }

    public Object getUniqueKey(String keyPrefix, Object[] values) {
        if (this.groupByProps != null) {
            StringBuffer keyBuffer = keyPrefix != null ? new StringBuffer(keyPrefix) : new StringBuffer();
            for (int i = 0; i < this.getResultMappings().length; ++i) {
                String propertyName = this.getResultMappings()[i].getPropertyName();
                if (!this.groupByProps.contains(propertyName)) continue;
                keyBuffer.append(values[i]);
                keyBuffer.append('-');
            }
            if (keyBuffer.length() < 1) {
                return null;
            }
            keyBuffer.append(KEY_SEPARATOR);
            return keyBuffer.toString();
        }
        return null;
    }

    public Object getUniqueKey(Object[] values) {
        return this.getUniqueKey(null, values);
    }

    public void setResultClass(Class resultClass) {
        this.resultClass = resultClass;
    }

    public DataExchange getDataExchange() {
        return this.dataExchange;
    }

    public void setDataExchange(DataExchange dataExchange) {
        this.dataExchange = dataExchange;
    }

    public String getXmlName() {
        return this.xmlName;
    }

    public void setXmlName(String xmlName) {
        this.xmlName = xmlName;
    }

    public String getResource() {
        return this.resource;
    }

    public void setResource(String resource) {
        this.resource = resource;
    }

    public void addGroupByProperty(String name) {
        if (this.groupByProps == null) {
            this.groupByProps = new HashSet();
        }
        this.groupByProps.add(name);
    }

    public boolean hasGroupBy() {
        return this.groupByProps != null && this.groupByProps.size() > 0;
    }

    public Iterator groupByProps() {
        return this.groupByProps.iterator();
    }

    public void addNestedResultMappings(ResultMapping mapping) {
        if (this.nestedResultMappings == null) {
            this.nestedResultMappings = new ArrayList();
        }
        this.nestedResultMappings.add(mapping);
    }

    public List getNestedResultMappings() {
        return this.nestedResultMappings;
    }

    public ResultMapping[] getResultMappings() {
        if (this.allowRemapping) {
            return (ResultMapping[])this.remappableResultMappings.get();
        }
        return this.resultMappings;
    }

    public void setDiscriminator(Discriminator discriminator) {
        if (this.discriminator != null) {
            throw new SqlMapException("A discriminator may only be set once per result map.");
        }
        this.discriminator = discriminator;
    }

    public Discriminator getDiscriminator() {
        return this.discriminator;
    }

    public ResultMap resolveSubMap(RequestScope request, ResultSet rs) throws SQLException {
        ResultMap subMap = this;
        if (this.discriminator != null) {
            BasicResultMapping mapping = (BasicResultMapping)this.discriminator.getResultMapping();
            Object value = this.getPrimitiveResultMappingValue(rs, mapping);
            if (value == null) {
                value = this.doNullMapping(value, mapping);
            }
            if ((subMap = this.discriminator.getSubMap(String.valueOf(value))) == null) {
                subMap = this;
            } else if (subMap != this) {
                subMap = subMap.resolveSubMap(request, rs);
            }
        }
        return subMap;
    }

    public void setResultMappingList(List resultMappingList) {
        if (this.allowRemapping) {
            this.remappableResultMappings.set(resultMappingList.toArray(new BasicResultMapping[resultMappingList.size()]));
        } else {
            this.resultMappings = resultMappingList.toArray(new BasicResultMapping[resultMappingList.size()]);
        }
        HashMap<String, BasicResultMap> props = new HashMap<String, BasicResultMap>();
        props.put("map", this);
        this.dataExchange = this.getDelegate().getDataExchangeFactory().getDataExchangeForClass(this.resultClass);
        this.dataExchange.initialize(props);
    }

    public int getResultCount() {
        return this.getResultMappings().length;
    }

    public Object[] getResults(RequestScope request, ResultSet rs) throws SQLException {
        ErrorContext errorContext = request.getErrorContext();
        errorContext.setActivity("applying a result map");
        errorContext.setObjectId(this.getId());
        errorContext.setResource(this.getResource());
        errorContext.setMoreInfo("Check the result map.");
        boolean foundData = false;
        Object[] columnValues = new Object[this.getResultMappings().length];
        for (int i = 0; i < this.getResultMappings().length; ++i) {
            BasicResultMapping mapping = (BasicResultMapping)this.getResultMappings()[i];
            errorContext.setMoreInfo(mapping.getErrorString());
            if (mapping.getStatementName() != null) {
                Class javaType;
                if (this.resultClass == null) {
                    throw new SqlMapException("The result class was null when trying to get results for ResultMap named " + this.getId() + ".");
                }
                if ((class$java$util$Map == null ? BasicResultMap.class$("java.util.Map") : class$java$util$Map).isAssignableFrom(this.resultClass)) {
                    javaType = mapping.getJavaType();
                    if (javaType == null) {
                        javaType = class$java$lang$Object == null ? BasicResultMap.class$("java.lang.Object") : class$java$lang$Object;
                    }
                    columnValues[i] = this.getNestedSelectMappingValue(request, rs, mapping, javaType);
                } else if ((class$com$ibatis$sqlmap$engine$type$DomTypeMarker == null ? BasicResultMap.class$("com.ibatis.sqlmap.engine.type.DomTypeMarker") : class$com$ibatis$sqlmap$engine$type$DomTypeMarker).isAssignableFrom(this.resultClass)) {
                    javaType = mapping.getJavaType();
                    if (javaType == null) {
                        javaType = class$com$ibatis$sqlmap$engine$type$DomTypeMarker == null ? BasicResultMap.class$("com.ibatis.sqlmap.engine.type.DomTypeMarker") : class$com$ibatis$sqlmap$engine$type$DomTypeMarker;
                    }
                    columnValues[i] = this.getNestedSelectMappingValue(request, rs, mapping, javaType);
                } else {
                    Probe p = ProbeFactory.getProbe((Object)this.resultClass);
                    Class type = p.getPropertyTypeForSetter((Object)this.resultClass, mapping.getPropertyName());
                    columnValues[i] = this.getNestedSelectMappingValue(request, rs, mapping, type);
                }
                foundData = foundData || columnValues[i] != null;
                continue;
            }
            if (mapping.getNestedResultMapName() != null) continue;
            columnValues[i] = this.getPrimitiveResultMappingValue(rs, mapping);
            if (columnValues[i] == null) {
                columnValues[i] = this.doNullMapping(columnValues[i], mapping);
                continue;
            }
            foundData = true;
        }
        request.setRowDataFound(foundData);
        return columnValues;
    }

    public Object setResultObjectValues(RequestScope request, Object resultObject, Object[] values) {
        String ukey = (String)this.getUniqueKey(request.getCurrentNestedKey(), values);
        HashMap<String, Object> uniqueKeys = request.getUniqueKeys(this);
        request.setCurrentNestedKey(ukey);
        if (uniqueKeys != null && uniqueKeys.containsKey(ukey)) {
            resultObject = uniqueKeys.get(ukey);
            this.applyNestedResultMap(request, resultObject, values);
            resultObject = ResultMap.NO_VALUE;
        } else if (ukey == null || uniqueKeys == null || !uniqueKeys.containsKey(ukey)) {
            resultObject = this.dataExchange.setData(request, this, resultObject, values);
            if (ukey != null) {
                if (uniqueKeys == null) {
                    uniqueKeys = new HashMap<String, Object>();
                    request.setUniqueKeys(this, uniqueKeys);
                }
                uniqueKeys.put(ukey, resultObject);
            }
            this.applyNestedResultMap(request, resultObject, values);
        } else {
            resultObject = ResultMap.NO_VALUE;
        }
        return resultObject;
    }

    private void applyNestedResultMap(RequestScope request, Object resultObject, Object[] values) {
        if (resultObject != null && resultObject != ResultMap.NO_VALUE && this.nestedResultMappings != null) {
            int n = this.nestedResultMappings.size();
            for (int i = 0; i < n; ++i) {
                BasicResultMapping resultMapping = (BasicResultMapping)this.nestedResultMappings.get(i);
                this.setNestedResultMappingValue(resultMapping, request, resultObject, values);
            }
        }
    }

    protected void setNestedResultMappingValue(BasicResultMapping mapping, RequestScope request, Object resultObject, Object[] values) {
        try {
            Object o;
            String resultMapName = mapping.getNestedResultMapName();
            ResultMap resultMap = this.getDelegate().getResultMap(resultMapName);
            resultMap = resultMap.resolveSubMap(request, request.getResultSet());
            Class type = mapping.getJavaType();
            String propertyName = mapping.getPropertyName();
            Object obj = PROBE.getObject(resultObject, propertyName);
            if (obj == null) {
                if (type == null) {
                    type = PROBE.getPropertyTypeForSetter(resultObject, propertyName);
                }
                try {
                    if ((class$java$util$Collection == null ? (class$java$util$Collection = BasicResultMap.class$("java.util.Collection")) : class$java$util$Collection).isAssignableFrom(type)) {
                        ExtendedSqlMapClient client = (ExtendedSqlMapClient)request.getSession().getSqlMapClient();
                        obj = ResultObjectFactoryUtil.createObjectThroughFactory(client.getResultObjectFactory(), request.getStatement().getId(), type);
                        PROBE.setObject(resultObject, propertyName, obj);
                    }
                }
                catch (Exception e) {
                    throw new SqlMapException("Error instantiating collection property for mapping '" + mapping.getPropertyName() + "'.  Cause: " + e, e);
                }
            }
            values = resultMap.getResults(request, request.getResultSet());
            if (request.isRowDataFound() && (o = resultMap.setResultObjectValues(request, null, values)) != ResultMap.NO_VALUE) {
                if (obj != null && obj instanceof Collection) {
                    ((Collection)obj).add(o);
                } else {
                    PROBE.setObject(resultObject, propertyName, o);
                }
            }
        }
        catch (SQLException e) {
            throw new SqlMapException("Error getting nested result map values for '" + mapping.getPropertyName() + "'.  Cause: " + e, e);
        }
    }

    protected Object getNestedSelectMappingValue(RequestScope request, ResultSet rs, BasicResultMapping mapping, Class targetType) throws SQLException {
        try {
            TypeHandlerFactory typeHandlerFactory = this.getDelegate().getTypeHandlerFactory();
            String statementName = mapping.getStatementName();
            ExtendedSqlMapClient client = (ExtendedSqlMapClient)request.getSession().getSqlMapClient();
            MappedStatement mappedStatement = client.getMappedStatement(statementName);
            Class parameterType = mappedStatement.getParameterClass();
            Object parameterObject = null;
            parameterObject = parameterType == null ? this.prepareBeanParameterObject(request, rs, mapping, parameterType) : (typeHandlerFactory.hasTypeHandler(parameterType) ? this.preparePrimitiveParameterObject(rs, mapping, parameterType) : ((class$com$ibatis$sqlmap$engine$type$DomTypeMarker == null ? (class$com$ibatis$sqlmap$engine$type$DomTypeMarker = BasicResultMap.class$("com.ibatis.sqlmap.engine.type.DomTypeMarker")) : class$com$ibatis$sqlmap$engine$type$DomTypeMarker).isAssignableFrom(parameterType) ? this.prepareDomParameterObject(rs, mapping) : this.prepareBeanParameterObject(request, rs, mapping, parameterType)));
            Object result = null;
            if (parameterObject != null) {
                TypeHandler typeHandler;
                Sql sql = mappedStatement.getSql();
                ResultMap resultMap = sql.getResultMap(request, parameterObject);
                Class resultClass = resultMap.getResultClass();
                if (resultClass != null && !(class$com$ibatis$sqlmap$engine$type$DomTypeMarker == null ? (class$com$ibatis$sqlmap$engine$type$DomTypeMarker = BasicResultMap.class$("com.ibatis.sqlmap.engine.type.DomTypeMarker")) : class$com$ibatis$sqlmap$engine$type$DomTypeMarker).isAssignableFrom(targetType)) {
                    if ((class$com$ibatis$sqlmap$engine$type$DomCollectionTypeMarker == null ? (class$com$ibatis$sqlmap$engine$type$DomCollectionTypeMarker = BasicResultMap.class$("com.ibatis.sqlmap.engine.type.DomCollectionTypeMarker")) : class$com$ibatis$sqlmap$engine$type$DomCollectionTypeMarker).isAssignableFrom(resultClass)) {
                        targetType = class$com$ibatis$sqlmap$engine$type$DomCollectionTypeMarker == null ? (class$com$ibatis$sqlmap$engine$type$DomCollectionTypeMarker = BasicResultMap.class$("com.ibatis.sqlmap.engine.type.DomCollectionTypeMarker")) : class$com$ibatis$sqlmap$engine$type$DomCollectionTypeMarker;
                    } else if ((class$com$ibatis$sqlmap$engine$type$DomTypeMarker == null ? (class$com$ibatis$sqlmap$engine$type$DomTypeMarker = BasicResultMap.class$("com.ibatis.sqlmap.engine.type.DomTypeMarker")) : class$com$ibatis$sqlmap$engine$type$DomTypeMarker).isAssignableFrom(resultClass)) {
                        targetType = class$com$ibatis$sqlmap$engine$type$DomTypeMarker == null ? (class$com$ibatis$sqlmap$engine$type$DomTypeMarker = BasicResultMap.class$("com.ibatis.sqlmap.engine.type.DomTypeMarker")) : class$com$ibatis$sqlmap$engine$type$DomTypeMarker;
                    }
                }
                result = ResultLoader.loadResult(client, statementName, parameterObject, targetType);
                String nullValue = mapping.getNullValue();
                if (result == null && nullValue != null && (typeHandler = typeHandlerFactory.getTypeHandler(targetType)) != null) {
                    result = typeHandler.valueOf(nullValue);
                }
            }
            return result;
        }
        catch (InstantiationException e) {
            throw new NestedSQLException("Error setting nested bean property.  Cause: " + e, (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new NestedSQLException("Error setting nested bean property.  Cause: " + e, (Throwable)e);
        }
    }

    private Object preparePrimitiveParameterObject(ResultSet rs, BasicResultMapping mapping, Class parameterType) throws SQLException {
        TypeHandlerFactory typeHandlerFactory = this.getDelegate().getTypeHandlerFactory();
        TypeHandler th = typeHandlerFactory.getTypeHandler(parameterType);
        Object parameterObject = th.getResult(rs, mapping.getColumnName());
        return parameterObject;
    }

    private Document newDocument(String root) {
        try {
            Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            doc.appendChild(doc.createElement(root));
            return doc;
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException("Error creating XML document.  Cause: " + e);
        }
    }

    private Object prepareDomParameterObject(ResultSet rs, BasicResultMapping mapping) throws SQLException {
        TypeHandlerFactory typeHandlerFactory = this.getDelegate().getTypeHandlerFactory();
        Document doc = this.newDocument("parameter");
        Probe probe = ProbeFactory.getProbe((Object)doc);
        String complexName = mapping.getColumnName();
        TypeHandler stringTypeHandler = typeHandlerFactory.getTypeHandler(class$java$lang$String == null ? (class$java$lang$String = BasicResultMap.class$("java.lang.String")) : class$java$lang$String);
        if (complexName.indexOf(61) > -1) {
            StringTokenizer parser = new StringTokenizer(complexName, "{}=, ", false);
            while (parser.hasMoreTokens()) {
                String propName = parser.nextToken();
                String colName = parser.nextToken();
                Object propValue = stringTypeHandler.getResult(rs, colName);
                probe.setObject((Object)doc, propName, (Object)propValue.toString());
            }
        } else {
            Object propValue = stringTypeHandler.getResult(rs, complexName);
            probe.setObject((Object)doc, "value", (Object)propValue.toString());
        }
        return doc;
    }

    private Object prepareBeanParameterObject(RequestScope request, ResultSet rs, BasicResultMapping mapping, Class parameterType) throws InstantiationException, IllegalAccessException, SQLException {
        Object parameterObject;
        TypeHandlerFactory typeHandlerFactory = this.getDelegate().getTypeHandlerFactory();
        if (parameterType == null) {
            parameterObject = new HashMap();
        } else {
            ExtendedSqlMapClient client = (ExtendedSqlMapClient)request.getSession().getSqlMapClient();
            parameterObject = ResultObjectFactoryUtil.createObjectThroughFactory(client.getResultObjectFactory(), request.getStatement().getId(), parameterType);
        }
        String complexName = mapping.getColumnName();
        if (complexName.indexOf(61) > -1 || complexName.indexOf(44) > -1) {
            StringTokenizer parser = new StringTokenizer(complexName, "{}=, ", false);
            while (parser.hasMoreTokens()) {
                String propName = parser.nextToken();
                String colName = parser.nextToken();
                Class propType = PROBE.getPropertyTypeForSetter(parameterObject, propName);
                TypeHandler propTypeHandler = typeHandlerFactory.getTypeHandler(propType);
                Object propValue = propTypeHandler.getResult(rs, colName);
                PROBE.setObject(parameterObject, propName, propValue);
            }
        } else {
            TypeHandler propTypeHandler = typeHandlerFactory.getTypeHandler(parameterType);
            if (propTypeHandler == null) {
                propTypeHandler = typeHandlerFactory.getUnkownTypeHandler();
            }
            parameterObject = propTypeHandler.getResult(rs, complexName);
        }
        return parameterObject;
    }

    protected Object getPrimitiveResultMappingValue(ResultSet rs, BasicResultMapping mapping) throws SQLException {
        Object value = null;
        TypeHandler typeHandler = mapping.getTypeHandler();
        if (typeHandler != null) {
            String columnName = mapping.getColumnName();
            int columnIndex = mapping.getColumnIndex();
            value = columnName == null ? typeHandler.getResult(rs, columnIndex) : typeHandler.getResult(rs, columnName);
        } else {
            throw new SqlMapException("No type handler could be found to map the property '" + mapping.getPropertyName() + "' to the column '" + mapping.getColumnName() + "'.  One or both of the types, or the combination of types is not supported.");
        }
        return value;
    }

    protected Object doNullMapping(Object value, BasicResultMapping mapping) throws SqlMapException {
        if (value == null) {
            TypeHandler typeHandler = mapping.getTypeHandler();
            if (typeHandler != null) {
                String nullValue = mapping.getNullValue();
                if (nullValue != null) {
                    value = typeHandler.valueOf(nullValue);
                }
                return value;
            }
            throw new SqlMapException("No type handler could be found to map the property '" + mapping.getPropertyName() + "' to the column '" + mapping.getColumnName() + "'.  One or both of the types, or the combination of types is not supported.");
        }
        return value;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

