/**
 * Board ü  Interface
 */
package org.springframework.samples.kyuriboard.dao;

import java.util.List;

import org.springframework.dao.DataAccessException;
import org.springframework.samples.kyuriboard.domain.Board;

/**
 * @author DAMI(archy712@naver.com)
 *
 */
public interface BoardDao {
	
	
	/**
	 * ־ ԽùID Խù ü ȯѴ.
	 * @param boardId ԽùID
	 * @return Board Խù ü
	 * @throws DataAccessException
	 */
	Board getBoardByBoardId(int boardId) throws DataAccessException;
	
	
	/**
	 * Խù  Ʈ ȯѴ.
	 * @return java.util.List Խù  Ʈ
	 * @throws DataAccessException
	 */
	List getBoardList() throws DataAccessException;
	
	
	/**
	 * ־ ID شϴ Խù Ʈ ȯѴ.
	 * @param userId ID
	 * @return java.util.List Խù Ʈ
	 * @throws DataAccessException
	 */
	List getBoardListByUserId(String userId) throws DataAccessException;
	
	
	/**
	 * ־ ڸ شϴ Խù Ʈ ȯѴ.
	 * @param userName ڸ
	 * @return java.util.List Խù Ʈ
	 * @throws DataAccessException
	 */
	List getBoardListByUserName(String userName) throws DataAccessException;
	
	
	/**
	 * ־  شϴ Խù Ʈ ȯѴ.
	 * @param title Խù 
	 * @return java.util.List Խù Ʈ
	 * @throws DataAccessException
	 */
	List getBoardListByTitle(String title) throws DataAccessException;
	
	
	/**
	 * ־ Խù ԷѴ.
	 * @param board Է Խù ü
	 * @throws DataAccessException
	 */
	void insertBoard(Board board) throws DataAccessException;
	
	
	/**
	 * ־ Խù Ѵ.
	 * @param board  Խù
	 * @throws DataAccessException
	 */
	void updateBoard(Board board) throws DataAccessException;
	
	
	/**
	 * ־ Խù Ѵ
	 * @param boardId  Խù ID
	 * @throws DataAccessException
	 */
	void deleteBoard(int boardId) throws DataAccessException;
	
	

}
