/**
 * Memo  ̽
 */
package org.springframework.samples.kyuriboard.dao;

import java.util.List;

import org.springframework.samples.kyuriboard.domain.Memo;
import org.springframework.dao.DataAccessException;

/**
 * @author DAMI(archy712@naver.com)
 *
 */
public interface MemoDao {
	
	
	/**
	 * ־ ޸ID ޸ ȯѴ.
	 * @param memoId ޸ID
	 * @return Memo ޸ ü
	 * @throws DataAccessException
	 */
	Memo getMemoByMemoId(int memoId) throws DataAccessException;
	
	
	/**
	 * ־ ԽID ޸ Ʈ ȯѴ.
	 * @param boardId ԽID
	 * @return java.util.List
	 * @throws DataAccessException
	 */
	List getMemoListByBoardId(int boardId) throws DataAccessException;
	
	
	/**
	 * ޸ ԷѴ.
	 * @param memo ޸ ü
	 * @throws DataAccessException
	 */
	void insertMemo(Memo memo) throws DataAccessException;
	
	
	/**
	 * ޸ Ѵ
	 * @param memo ޸ ü
	 * @throws DataAccessException
	 */
	void updateMemo(Memo memo) throws DataAccessException;
	
	
	/**
	 * ޸ Ѵ
	 * @param memoId  ޸ ID
	 * @throws DataAccessException
	 */
	void deleteMemo(int memoId) throws DataAccessException;
	
	
	/**
	 * ־ ԽùID شϴ ޸ Ѵ
	 * @param boardId  Խù ID
	 * @throws DataAccessException
	 */
	void deleteMemoByBoardId(int boardId) throws DataAccessException;
}
