/**
 *   ̽
 */
package org.springframework.samples.kyuriboard.dao;

import java.util.List;

import org.springframework.dao.DataAccessException;
import org.springframework.samples.kyuriboard.domain.User;

/**
 * @author DAMI(archy712@naver.com)
 *
 * User  Ŭ  ó
 */
public interface UserDao {
	
	
	/**
	 * ־ ID ڸ ȯѴ. 
	 * @param userId ID
	 * @return User 
	 * @throws DataAccessException
	 */
	User getUserByUserId(String userId) throws DataAccessException;
	
	
	/**
	 * ־ ID йȣ ڸ ȯѴ.
	 * @param userId ID
	 * @param passwd  йȣ
	 * @return User 
	 * @throws DataAccessException
	 */
	User getUserByUserIdAndPasswd(String userId, String passwd) throws DataAccessException;
	
	
	/**
	 * ־ ڸ ԷѴ.
	 * @param user 
	 * @throws DataAccessException
	 */
	void insertUser(User user) throws DataAccessException;
	
	
	/**
	 * ־ ڸ Ѵ.
	 * @param user 
	 * @throws DataAccessException
	 */
	void updateUser(User user) throws DataAccessException;
	
	
	/**
	 *  Ʈ ȯѴ.
	 * @return java.util.List  Ʈ
	 * @throws DataAccessException
	 */
	List getUserList() throws DataAccessException;
	

}
