/**
 * 
 */
package org.springframework.samples.kyuriboard.dao.ibatis;

import java.util.List;

import org.springframework.dao.DataAccessException;
import org.springframework.orm.ibatis.support.SqlMapClientDaoSupport;
import org.springframework.samples.kyuriboard.dao.BoardDao;
import org.springframework.samples.kyuriboard.domain.Board;

/**
 * @author DAMI(archy712@naver.com)
 *
 */
public class SqlMapBoardDao extends SqlMapClientDaoSupport implements BoardDao {
	
	private SqlMapSequenceDao sequenceDao;
	
	public void setSequenceDao(SqlMapSequenceDao sequenceDao) {
		this.sequenceDao = sequenceDao;
	}

	/* (non-Javadoc)
	 * @see org.springframework.samples.kyuriboard.dao.BoardDao#deleteBoard(int)
	 */
	public void deleteBoard(int boardId) throws DataAccessException {
		// TODO Auto-generated method stub
		Object parameterObject = new Integer(boardId);
		getSqlMapClientTemplate().delete("deleteBoard", parameterObject);
	}

	/* (non-Javadoc)
	 * @see org.springframework.samples.kyuriboard.dao.BoardDao#getBoardByBoardId(int)
	 */
	public Board getBoardByBoardId(int boardId) throws DataAccessException {
		// TODO Auto-generated method stub
		Object parameterObject = new Integer(boardId);
		return (Board) getSqlMapClientTemplate().queryForObject("getBoardByBoardId", parameterObject);
	}

	/* (non-Javadoc)
	 * @see org.springframework.samples.kyuriboard.dao.BoardDao#getBoardList()
	 */
	public List getBoardList() throws DataAccessException {
		// TODO Auto-generated method stub
		return getSqlMapClientTemplate().queryForList("getBoardList");
	}

	/* (non-Javadoc)
	 * @see org.springframework.samples.kyuriboard.dao.BoardDao#getBoardListByTitle(java.lang.String)
	 */
	public List getBoardListByTitle(String title) throws DataAccessException {
		// TODO Auto-generated method stub
		return getSqlMapClientTemplate().queryForList("getBoardListByTitle", title);
	}

	/* (non-Javadoc)
	 * @see org.springframework.samples.kyuriboard.dao.BoardDao#getBoardListByUserId(java.lang.String)
	 */
	public List getBoardListByUserId(String userId) throws DataAccessException {
		// TODO Auto-generated method stub
		return getSqlMapClientTemplate().queryForList("getBoardListByUserId", userId);
	}

	/* (non-Javadoc)
	 * @see org.springframework.samples.kyuriboard.dao.BoardDao#getBoardListByUserName(java.lang.String)
	 */
	public List getBoardListByUserName(String userName)
			throws DataAccessException {
		// TODO Auto-generated method stub
		return getSqlMapClientTemplate().queryForList("getBoardListByUserName", userName);
	}

	/* (non-Javadoc)
	 * @see org.springframework.samples.kyuriboard.dao.BoardDao#insertBoard(org.springframework.samples.kyuriboard.domain.Board)
	 */
	public void insertBoard(Board board) throws DataAccessException {
		// TODO Auto-generated method stub
		board.setBoardId(this.sequenceDao.getNextId("boardid"));
		getSqlMapClientTemplate().insert("insertBoard", board);
	}

	/* (non-Javadoc)
	 * @see org.springframework.samples.kyuriboard.dao.BoardDao#updateBoard(org.springframework.samples.kyuriboard.domain.Board)
	 */
	public void updateBoard(Board board) throws DataAccessException {
		// TODO Auto-generated method stub
		getSqlMapClientTemplate().update("updateBoard", board);
	}



}
