/**
 * 
 */
package org.springframework.samples.kyuriboard.dao.ibatis;

import java.util.List;

import org.springframework.dao.DataAccessException;
import org.springframework.orm.ibatis.support.SqlMapClientDaoSupport;
import org.springframework.samples.kyuriboard.dao.MemoDao;
import org.springframework.samples.kyuriboard.domain.Memo;

/**
 * @author DAMI(archy712@naver.com)
 *
 */
public class SqlMapMemoDao extends SqlMapClientDaoSupport implements MemoDao {
	
	private SqlMapSequenceDao sequenceDao;
	
	public void setSequenceDao(SqlMapSequenceDao sequenceDao) {
		this.sequenceDao = sequenceDao;
	}

	/* (non-Javadoc)
	 * @see org.springframework.samples.kyuriboard.dao.MemoDao#deleteMemo(int)
	 */
	public void deleteMemo(int memoId) throws DataAccessException {
		// TODO Auto-generated method stub
		Object parameterObject = new Integer(memoId);
		getSqlMapClientTemplate().delete("deleteMemo", parameterObject);
	}

	/* (non-Javadoc)
	 * @see org.springframework.samples.kyuriboard.dao.MemoDao#getMemoByMemoId(int)
	 */
	public Memo getMemoByMemoId(int memoId) throws DataAccessException {
		// TODO Auto-generated method stub
		Object parameterObject = new Integer(memoId);
		return (Memo) getSqlMapClientTemplate().queryForObject("getMemoByMemoId", parameterObject);
	}

	/* (non-Javadoc)
	 * @see org.springframework.samples.kyuriboard.dao.MemoDao#getMemoListByBoardId(int)
	 */
	public List getMemoListByBoardId(int boardId) throws DataAccessException {
		// TODO Auto-generated method stub
		Object parameterObject = new Integer(boardId);
		return getSqlMapClientTemplate().queryForList("getMemoListByBoardId", parameterObject);
	}

	/* (non-Javadoc)
	 * @see org.springframework.samples.kyuriboard.dao.MemoDao#insertMemo(org.springframework.samples.kyuriboard.domain.Memo)
	 */
	public void insertMemo(Memo memo) throws DataAccessException {
		// TODO Auto-generated method stub
		memo.setMemoId(this.sequenceDao.getNextId("memoid"));
		getSqlMapClientTemplate().insert("insertMemo", memo);
	}

	/* (non-Javadoc)
	 * @see org.springframework.samples.kyuriboard.dao.MemoDao#updateMemo(org.springframework.samples.kyuriboard.domain.Memo)
	 */
	public void updateMemo(Memo memo) throws DataAccessException {
		// TODO Auto-generated method stub
		getSqlMapClientTemplate().update("updateMemo", memo);
	}

	public void deleteMemoByBoardId(int boardId) throws DataAccessException {
		// TODO Auto-generated method stub
		Object parameterObject = new Integer(boardId);
		getSqlMapClientTemplate().update("deleteMemoByBoardId", parameterObject);
	}

}
