/**
 * 
 */
package org.springframework.samples.kyuriboard.dao.ibatis;

import org.springframework.orm.ibatis.support.SqlMapClientDaoSupport;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.DataRetrievalFailureException;

/**
 * @author DAMI(archy712@naver.com)
 *
 */
public class SqlMapSequenceDao extends SqlMapClientDaoSupport {
	
	/**
	 *   ID , ش  ȣ 1  Ų.
	 * @param name ش  
	 * @return   
	 * @throws DataAccessException ش  Row ã  .
	 */
	public int getNextId(String name) throws DataAccessException {
		Sequence sequence = new Sequence(name, -1);
		sequence = (Sequence) getSqlMapClientTemplate().queryForObject("getSequence", sequence);
		if (sequence == null) {
			throw new DataRetrievalFailureException("Could not get next value of sequence [" + name + "] : sequence does not exist");
		}
		Object parameterObject = new Sequence(name, sequence.getNextId() + 1);
		getSqlMapClientTemplate().update("updateSequence", parameterObject, 1);
		return sequence.getNextId();
	}

}
