/**
 * 
 */
package org.springframework.samples.kyuriboard.dao.ibatis;

import java.util.List;

import org.springframework.dao.DataAccessException;
import org.springframework.orm.ibatis.support.SqlMapClientDaoSupport;
import org.springframework.samples.kyuriboard.dao.UserDao;
import org.springframework.samples.kyuriboard.domain.User;

/**
 * @author DAMI(archy712@naver.com)
 *
 */
public class SqlMapUserDao extends SqlMapClientDaoSupport implements UserDao {

	/* (non-Javadoc)
	 * @see org.springframework.samples.kyuriboard.dao.UserDao#getUserByUserId(java.lang.String)
	 */
	public User getUserByUserId(String userId) throws DataAccessException {
		// TODO Auto-generated method stub
		return (User) getSqlMapClientTemplate().queryForObject("getUserByUserId", userId);
	}

	/* (non-Javadoc)
	 * @see org.springframework.samples.kyuriboard.dao.UserDao#getUserByUserIdAndPasswd(java.lang.String, java.lang.String)
	 */
	public User getUserByUserIdAndPasswd(String userId, String passwd)
			throws DataAccessException {
		// TODO Auto-generated method stub
		User user = new User();
		user.setUserId(userId);
		user.setPasswd(passwd);
		return (User) getSqlMapClientTemplate().queryForObject("getUserByUserIdAndPasswd", user);
	}

	/* (non-Javadoc)
	 * @see org.springframework.samples.kyuriboard.dao.UserDao#getUserList()
	 */
	public List getUserList() throws DataAccessException {
		// TODO Auto-generated method stub
		return getSqlMapClientTemplate().queryForList("getUserList", null);
	}

	/* (non-Javadoc)
	 * @see org.springframework.samples.kyuriboard.dao.UserDao#insertUser(org.springframework.samples.kyuriboard.domain.User)
	 */
	public void insertUser(User user) throws DataAccessException {
		// TODO Auto-generated method stub
		getSqlMapClientTemplate().insert("insertUser", user);
	}

	/* (non-Javadoc)
	 * @see org.springframework.samples.kyuriboard.dao.UserDao#updateUser(org.springframework.samples.kyuriboard.domain.User)
	 */
	public void updateUser(User user) throws DataAccessException {
		// TODO Auto-generated method stub
		getSqlMapClientTemplate().update("updateUser", user);
	}

}
