/**
 * 
 */
package org.springframework.samples.kyuriboard.domain.logic;

import java.util.List;

import org.springframework.dao.DataAccessException;
import org.springframework.samples.kyuriboard.domain.Board;
import org.springframework.samples.kyuriboard.domain.Memo;
import org.springframework.samples.kyuriboard.domain.User;

/**
 * @author DAMI(archy712@naver.com)
 *
 */
public interface KyuriBoardFacade {
	
	// -----------------------------------------------------------
	// Board
	// -----------------------------------------------------------
	
	/**
	 * ־ ԽùID Խù ü ȯѴ
	 * @param boardId ԽùID
	 * @return Board Խù ü
	 * @throws DataAccessException
	 */
	Board getBoardByBoardId(int boardId) throws DataAccessException;
	
	
	/**
	 * Խù  Ʈ ȯѴ.
	 * @return java.util.List Խù  Ʈ
	 * @throws DataAccessException
	 */
	List getBoardList() throws DataAccessException;
	
	
	/**
	 * ־ ID شϴ Խù Ʈ ȯѴ.
	 * @param userId ID
	 * @return java.util.List Խù Ʈ
	 * @throws DataAccessException
	 */
	List getBoardListByUserId(String userId) throws DataAccessException;
	
	
	/**
	 * ־ ڸ شϴ Խù Ʈ ȯѴ.
	 * @param userName ڸ
	 * @return java.util.List Խù Ʈ
	 * @throws DataAccessException
	 */
	List getBoardListByUserName(String userName) throws DataAccessException;
	
	
	/**
	 * ־  شϴ Խù Ʈ ȯѴ.
	 * @param title Խù 
	 * @return java.util.List Խù Ʈ
	 * @throws DataAccessException
	 */
	List getBoardListByTitle(String title) throws DataAccessException;
	
	
	/**
	 * ־ Խù ԷѴ.
	 * @param board Է Խù
	 * @throws DataAccessException
	 */
	void insertBoard(Board board) throws DataAccessException;
	
	
	/**
	 * ־ Խù Ѵ.
	 * @param board Է Խù
	 * @throws DataAccessException
	 */
	void updateBoard(Board board) throws DataAccessException;
	
	
	/**
	 * ־ Խù Ѵ.
	 * @param boardId  Խù ID
	 * @throws DataAccessException
	 */
	void deleteBoard(int boardId) throws DataAccessException;
	
	
	// ---------------------------------------------------------
	// Memo
	// ---------------------------------------------------------
	
	
	/**
	 * ־ ޸ID شϴ ޸ ȯѴ.
	 * @param memoId ޸ID
	 * @return Memo ޸ ü
	 * @throws DataAccessException
	 */
	Memo getMemoByMemoId(int memoId) throws DataAccessException;
	
	
	/**
	 * ־ ԽùID شϴ ޸ Ʈ ȯѴ.
	 * @param boardId ԽùID
	 * @return java.util.List ޸ Ʈ
	 * @throws DataAccessException
	 */
	List getMemoListByBoardId(int boardId) throws DataAccessException;
	
	
	/**
	 * ־ ޸ ԷѴ.
	 * @param memo Է ޸
	 * @throws DataAccessException
	 */
	void insertMemo(Memo memo) throws DataAccessException;
	
	
	/**
	 * ־ ޸ Ѵ.
	 * @param memo  ޸
	 * @throws DataAccessException
	 */
	void updateMemo(Memo memo) throws DataAccessException;
	
	
	/**
	 * ־ ޸ID شϴ ޸ Ѵ.
	 * @param memoId  ޸ ID
	 * @throws DataAccessException
	 */
	void deleteMemo(int memoId) throws DataAccessException;
	
	
	/**
	 * ־ ԽùID شϴ ޸ Ѵ.
	 * @param boardId
	 * @throws DataAccessException
	 */
	void deleteMemoByBoardId(int boardId) throws DataAccessException;
	
	
	// ---------------------------------------------------------
	// User
	// ---------------------------------------------------------
	

	/**
	 * ־ ID شϴ ڸ ȯѴ.
	 * @param userId  ID
	 * @return User 
	 * @throws DataAccessException
	 */
	User getUserByUserId(String userId) throws DataAccessException;
	
	
	/**
	 * ־ ID йȣ ϴ ڸ ȯѴ.
	 * @param userId  ID
	 * @param passwd  йȣ
	 * @return User 
	 * @throws DataAccessException
	 */
	User getUserByUserIdAndPasswd(String userId, String passwd) throws DataAccessException;
	
	
	/**
	 * ־ ڸ Ѵ.
	 * @param user  
	 * @throws DataAccessException
	 */
	void insertUser(User user) throws DataAccessException;
	
	
	/**
	 * ־ ڸ Ѵ.
	 * @param user  
	 * @throws DataAccessException
	 */
	void updateUser(User user) throws DataAccessException;
	
	
	/**
	 *  Ʈ ȯѴ.
	 * @return java.util.List  Ʈ
	 * @throws DataAccessException
	 */
	List getUserList() throws DataAccessException;

}
