/**
 * 
 */
package org.springframework.samples.kyuriboard.domain.logic;

import java.util.List;

import org.springframework.dao.DataAccessException;
import org.springframework.samples.kyuriboard.dao.BoardDao;
import org.springframework.samples.kyuriboard.dao.MemoDao;
import org.springframework.samples.kyuriboard.dao.UserDao;
import org.springframework.samples.kyuriboard.domain.Board;
import org.springframework.samples.kyuriboard.domain.Memo;
import org.springframework.samples.kyuriboard.domain.User;

/**
 * @author DAMI(archy712@naver.com)
 *
 */
public class KyuriBoardImpl implements KyuriBoardFacade {
	
	private BoardDao boardDao;
	
	private MemoDao memoDao;
	
	private UserDao userDao;
	
	// -----------------------------------------------------
	// Setter Injection
	// -----------------------------------------------------	

	/**
	 * @param boardDao the boardDao to set
	 */
	public void setBoardDao(BoardDao boardDao) {
		this.boardDao = boardDao;
	}

	/**
	 * @param memoDao the memoDao to set
	 */
	public void setMemoDao(MemoDao memoDao) {
		this.memoDao = memoDao;
	}

	/**
	 * @param userDao the userDao to set
	 */
	public void setUserDao(UserDao userDao) {
		this.userDao = userDao;
	}

	/*
	 * (non-Javadoc)
	 * @see org.springframework.samples.kyuriboard.domain.logic.KyuriBoardFacade#deleteBoard(int)
	 */
	public void deleteBoard(int boardId) throws DataAccessException {
		// TODO Auto-generated method stub
		this.boardDao.deleteBoard(boardId);
	}

	/* (non-Javadoc)
	 * @see org.springframework.samples.kyuriboard.domain.logic.KyuriBoardFacade#deleteMemo(int)
	 */
	public void deleteMemo(int memoId) throws DataAccessException {
		// TODO Auto-generated method stub
		this.memoDao.deleteMemo(memoId);
	}

	/* (non-Javadoc)
	 * @see org.springframework.samples.kyuriboard.domain.logic.KyuriBoardFacade#getBoardByBoardId(int)
	 */
	public Board getBoardByBoardId(int boardId) throws DataAccessException {
		// TODO Auto-generated method stub
		return this.boardDao.getBoardByBoardId(boardId);
	}

	/* (non-Javadoc)
	 * @see org.springframework.samples.kyuriboard.domain.logic.KyuriBoardFacade#getBoardList()
	 */
	public List getBoardList() throws DataAccessException {
		// TODO Auto-generated method stub
		return this.boardDao.getBoardList();
	}

	/* (non-Javadoc)
	 * @see org.springframework.samples.kyuriboard.domain.logic.KyuriBoardFacade#getBoardListByTitle(java.lang.String)
	 */
	public List getBoardListByTitle(String title) throws DataAccessException {
		// TODO Auto-generated method stub
		return this.boardDao.getBoardListByTitle(title);
	}

	/* (non-Javadoc)
	 * @see org.springframework.samples.kyuriboard.domain.logic.KyuriBoardFacade#getBoardListByUserId(java.lang.String)
	 */
	public List getBoardListByUserId(String userId) throws DataAccessException {
		// TODO Auto-generated method stub
		return this.boardDao.getBoardListByUserId(userId);
	}

	/* (non-Javadoc)
	 * @see org.springframework.samples.kyuriboard.domain.logic.KyuriBoardFacade#getBoardListByUserName(java.lang.String)
	 */
	public List getBoardListByUserName(String userName)
			throws DataAccessException {
		// TODO Auto-generated method stub
		return this.boardDao.getBoardListByUserName(userName);
	}

	/* (non-Javadoc)
	 * @see org.springframework.samples.kyuriboard.domain.logic.KyuriBoardFacade#getMemoByMemoId(int)
	 */
	public Memo getMemoByMemoId(int memoId) throws DataAccessException {
		// TODO Auto-generated method stub
		return this.memoDao.getMemoByMemoId(memoId);
	}

	/* (non-Javadoc)
	 * @see org.springframework.samples.kyuriboard.domain.logic.KyuriBoardFacade#getMemoListByBoardId(int)
	 */
	public List getMemoListByBoardId(int boardId) throws DataAccessException {
		// TODO Auto-generated method stub
		return this.memoDao.getMemoListByBoardId(boardId);
	}

	/* (non-Javadoc)
	 * @see org.springframework.samples.kyuriboard.domain.logic.KyuriBoardFacade#getUserByUserId(java.lang.String)
	 */
	public User getUserByUserId(String userId) throws DataAccessException {
		// TODO Auto-generated method stub
		return this.userDao.getUserByUserId(userId);
	}

	/* (non-Javadoc)
	 * @see org.springframework.samples.kyuriboard.domain.logic.KyuriBoardFacade#getUserByUserIdAndPasswd(java.lang.String, java.lang.String)
	 */
	public User getUserByUserIdAndPasswd(String userId, String passwd)
			throws DataAccessException {
		// TODO Auto-generated method stub
		return this.userDao.getUserByUserIdAndPasswd(userId, passwd);
	}

	/* (non-Javadoc)
	 * @see org.springframework.samples.kyuriboard.domain.logic.KyuriBoardFacade#getUserList()
	 */
	public List getUserList() throws DataAccessException {
		// TODO Auto-generated method stub
		return this.userDao.getUserList();
	}

	/* (non-Javadoc)
	 * @see org.springframework.samples.kyuriboard.domain.logic.KyuriBoardFacade#insertBoard(org.springframework.samples.kyuriboard.domain.Board)
	 */
	public void insertBoard(Board board) throws DataAccessException {
		// TODO Auto-generated method stub
		this.boardDao.insertBoard(board);
	}

	/* (non-Javadoc)
	 * @see org.springframework.samples.kyuriboard.domain.logic.KyuriBoardFacade#insertMemo(org.springframework.samples.kyuriboard.domain.Memo)
	 */
	public void insertMemo(Memo memo) throws DataAccessException {
		// TODO Auto-generated method stub
		this.memoDao.insertMemo(memo);
	}

	/* (non-Javadoc)
	 * @see org.springframework.samples.kyuriboard.domain.logic.KyuriBoardFacade#insertUser(org.springframework.samples.kyuriboard.domain.User)
	 */
	public void insertUser(User user) throws DataAccessException {
		// TODO Auto-generated method stub
		this.userDao.insertUser(user);
	}

	/* (non-Javadoc)
	 * @see org.springframework.samples.kyuriboard.domain.logic.KyuriBoardFacade#updateBoard(org.springframework.samples.kyuriboard.domain.Board)
	 */
	public void updateBoard(Board board) throws DataAccessException {
		// TODO Auto-generated method stub
		this.boardDao.updateBoard(board);
	}

	/* (non-Javadoc)
	 * @see org.springframework.samples.kyuriboard.domain.logic.KyuriBoardFacade#updateMemo(org.springframework.samples.kyuriboard.domain.Memo)
	 */
	public void updateMemo(Memo memo) throws DataAccessException {
		// TODO Auto-generated method stub
		this.memoDao.updateMemo(memo);
	}

	/* (non-Javadoc)
	 * @see org.springframework.samples.kyuriboard.domain.logic.KyuriBoardFacade#updateUser(org.springframework.samples.kyuriboard.domain.User)
	 */
	public void updateUser(User user) throws DataAccessException {
		// TODO Auto-generated method stub
		this.userDao.updateUser(user);
	}

	public void deleteMemoByBoardId(int boardId) throws DataAccessException {
		// TODO Auto-generated method stub
		this.memoDao.deleteMemoByBoardId(boardId);
	}

}
