/**
 * 
 */
package org.springframework.samples.kyuriboard.domain.logic;

import org.springframework.samples.kyuriboard.domain.User;
import org.springframework.validation.Errors;
import org.springframework.validation.Validator;
import org.springframework.validation.ValidationUtils;

/**
 * @author DAMI(archy712@naver.com)
 *
 */
public class UserValidator implements Validator {

	/* (non-Javadoc)
	 * @see org.springframework.validation.Validator#supports(java.lang.Class)
	 */
	public boolean supports(Class clazz) {
		// TODO Auto-generated method stub
		return User.class.isAssignableFrom(clazz);
	}

	/* (non-Javadoc)
	 * @see org.springframework.validation.Validator#validate(java.lang.Object, org.springframework.validation.Errors)
	 */
	public void validate(Object obj, Errors errors) {
		// TODO Auto-generated method stub
		ValidationUtils.rejectIfEmpty(errors, "userId", "USERID_REQUIRED", "ID ʿմϴ");
		ValidationUtils.rejectIfEmpty(errors, "userName", "USERNAME_REQUIRED", " ̸ ʿմϴ");
		ValidationUtils.rejectIfEmpty(errors, "passwd", "PASSWD_REQUIRED", "йȣ ʿմϴ");
		ValidationUtils.rejectIfEmpty(errors, "email", "EMAIL_REQUIRED", "̸ ּҰ ʿմϴ");
	}

}
