/**
 * 
 */
package org.springframework.samples.kyuriboard.web.spring;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.Controller;

import org.springframework.samples.kyuriboard.domain.logic.KyuriBoardFacade;

/**
 * @author DAMI(archy712@naver.com)
 *
 */
public class DeleteBoardController implements Controller {
	
	private KyuriBoardFacade kyuriBoard;	
	
	private String successView;

	/**
	 * @param kyuriBoard the kyuriBoard to set
	 */
	public void setKyuriBoard(KyuriBoardFacade kyuriBoard) {
		this.kyuriBoard = kyuriBoard;
	}
	

	/**
	 * @param successView the successView to set
	 */
	public void setSuccessView(String successView) {
		this.successView = successView;
	}


	/* (non-Javadoc)
	 * @see org.springframework.web.servlet.mvc.Controller#handleRequest(javax.servlet.http.HttpServletRequest, javax.servlet.http.HttpServletResponse)
	 */
	public ModelAndView handleRequest(HttpServletRequest request,
			HttpServletResponse response) throws Exception {
		// TODO Auto-generated method stub
		int boardId = new Integer(request.getParameter("boardId")).intValue();
		this.kyuriBoard.deleteBoard(boardId);
		this.kyuriBoard.deleteMemoByBoardId(boardId);
		return new ModelAndView(this.successView);
	}

}
