/**
 * Խù  ޸ 
 */
package org.springframework.samples.kyuriboard.web.spring;

import java.util.Map;
import java.util.HashMap;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.Controller;

import org.springframework.samples.kyuriboard.domain.Board;
import org.springframework.samples.kyuriboard.domain.Memo;
import org.springframework.samples.kyuriboard.domain.logic.KyuriBoardFacade;

/**
 * @author DAMI(archy712@naver.com)
 *
 */
public class InsertMemoController implements Controller {
	
	private KyuriBoardFacade kyuriBoard;

	/**
	 * @param kyuriBoard the kyuriBoard to set
	 */
	public void setKyuriBoard(KyuriBoardFacade kyuriBoard) {
		this.kyuriBoard = kyuriBoard;
	}

	/* (non-Javadoc)
	 * @see org.springframework.web.servlet.mvc.Controller#handleRequest(javax.servlet.http.HttpServletRequest, javax.servlet.http.HttpServletResponse)
	 */
	public ModelAndView handleRequest(HttpServletRequest request,
			HttpServletResponse response) throws Exception {
		// TODO Auto-generated method stub
		int boardId = new Integer(request.getParameter("boardId")).intValue();
		String content = new String(request.getParameter("content").getBytes("8859_1"), "euc-kr");
		UserSession userSession = (UserSession) request.getSession().getAttribute("userSession");
		Memo memo = new Memo();
		memo.setBoardId(boardId);
		memo.setContent(content);
		memo.setInsertDate(new java.util.Date());
		memo.setUserId(userSession.getUser().getUserId());
		this.kyuriBoard.insertMemo(memo);
		
		Board board = this.kyuriBoard.getBoardByBoardId(boardId);
		List memoList = this.kyuriBoard.getMemoListByBoardId(boardId);		
		
		Map model = new HashMap();
		model.put("board", board);
		model.put("memoList", memoList);
		
		return new ModelAndView("viewBoard", model);
	}

}
