/**
 * 
 */
package org.springframework.samples.kyuriboard.web.spring;

import java.util.Map;
import java.util.HashMap;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.support.PagedListHolder;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.Controller;
import org.springframework.samples.kyuriboard.domain.logic.KyuriBoardFacade;

import org.apache.log4j.Logger;

/**
 * @author DAMI(archy712@naver.com)
 *
 */
public class ListBoardController implements Controller {
	
	protected Logger logger = Logger.getLogger(getClass());
	
	private String successView;
	
	// Listȭ Searchȭ ϴ 
	private String mode;
	
	private KyuriBoardFacade kyuriBoard;	
	
	/**
	 * 
	 * @param mode the mode to set
	 */
	public void setMode(String mode) {
		this.mode = mode;
	}

	/**
	 * 
	 * @param successView
	 */
	public void setSuccessView(String successView) {
		this.successView = successView;
	}
	
	/**
	 * 
	 * @param kyuriBoard
	 */
	public void setKyuriBoard(KyuriBoardFacade kyuriBoard) {
		this.kyuriBoard = kyuriBoard;
	}

	/* (non-Javadoc)
	 * @see org.springframework.web.servlet.mvc.Controller#handleRequest(javax.servlet.http.HttpServletRequest, javax.servlet.http.HttpServletResponse)
	 */
	public ModelAndView handleRequest(HttpServletRequest request,
			HttpServletResponse response) throws Exception {
		// TODO Auto-generated method stub
		
		Map model = new HashMap();
		String page = request.getParameter("page");
		String searchKey = request.getParameter("searchKey");
		String searchVal = request.getParameter("searchVal");
		
		if (logger.isInfoEnabled()) {
			logger.info("searchKey : " + searchKey);
			logger.info("searchVal : " + searchVal);
		}
		
		if (searchVal != null) {
			searchVal = new String(searchVal.getBytes("8859_1"), "euc-kr");		// Ĺ ڿ ó
		}
		
		//System.out.println("searchKey : " + searchKey);
		//System.out.println("searchVal : " + searchVal);
		
		model.put("searchKey", searchKey);
		model.put("searchVal", searchVal);
		
		if (page == null) {
			page = "1";
		}
		
		//   شϴ Խù Ʈ 
		PagedListHolder boardList = null;
		if ("search".equals(this.mode)) {
			if ("writer".equals(searchKey)) {
				boardList = new PagedListHolder(this.kyuriBoard.getBoardListByUserName(searchVal));
			} else {
				boardList = new PagedListHolder(this.kyuriBoard.getBoardListByTitle(searchVal));
			}
		} else {
			boardList = new PagedListHolder(this.kyuriBoard.getBoardList());
		}
		boardList.setPageSize(20);	//   ڵ  20 
		boardList.setPage(new Integer(page).intValue() - 1);	// PagedListHolder ε 0 
		model.put("boardList", boardList);
		
		//  ٷ 
		int pagedGroup = 10;
		int nPage = new Integer(page).intValue();	//    ȯ
		int pagedLoop = pagedGroup;		//  Loop  MAX  
		if (pagedLoop > boardList.getPageCount()) {
			pagedLoop = boardList.getPageCount();	//  Loop     Ŭ  
		}
		String deli = new String(" ");	// 
		StringBuffer sb = new StringBuffer();
		
		if ((boardList.getPageCount() > pagedGroup) && (nPage > pagedGroup)) {
			sb.append("<a href=\"listBoard.do?page=" + (nPage - pagedGroup));
			if ((searchKey != null) && (searchVal != null)) {
				sb.append("?searchKey=" + searchKey + "&searchVal=" + searchVal);
			}
			sb.append("\">");
			sb.append("[ " + pagedGroup + "]");
			sb.append("</a>");
			sb.append(deli);
		}
		
		for (int i = 0; i < pagedLoop; i++) {
			sb.append("<a href=\"listBoard.do?page=" + (i + 1));
			if ((searchKey != null) && (searchVal != null)) {
				sb.append("?searchKey=" + searchKey + "&searchVal=" + searchVal);
			}			
			sb.append("\">");
			sb.append(i + 1);
			sb.append("</a>");
			sb.append(deli);
		}
		
		if ((boardList.getPageCount() > pagedGroup) && (nPage < pagedGroup)) {
			sb.append("<a href=\"listBoard.do?page=" + (nPage + pagedGroup));
			if ((searchKey != null) && (searchVal != null)) {
				sb.append("?searchKey=" + searchKey + "&searchVal=" + searchVal);
			}			
			sb.append("\">");
			sb.append("[ " + pagedGroup + "]");
			sb.append("</a>");
		}
		model.put("pagedLink", sb.toString());	//  ü 
		
		return new ModelAndView(this.successView, model);
	}

}
