/**
 * 
 */
package org.springframework.samples.kyuriboard.web.spring;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.springframework.samples.kyuriboard.domain.User;
import org.springframework.samples.kyuriboard.domain.logic.KyuriBoardFacade;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.Controller;

/**
 * @author DAMI(archy712@naver.com)
 *
 */
public class LogonController implements Controller {
	
	private KyuriBoardFacade kyuriBoard;
	
	public void setKyuriBoard(KyuriBoardFacade kyuriBoard) {
		this.kyuriBoard = kyuriBoard;
	}

	/* (non-Javadoc)
	 * @see org.springframework.web.servlet.mvc.Controller#handleRequest(javax.servlet.http.HttpServletRequest, javax.servlet.http.HttpServletResponse)
	 */
	public ModelAndView handleRequest(HttpServletRequest request,
			HttpServletResponse response) throws Exception {
		// TODO Auto-generated method stub
		String userId = request.getParameter("userId");
		String passwd = request.getParameter("passwd");
		User user = this.kyuriBoard.getUserByUserIdAndPasswd(userId, passwd);
		if (user == null) {
			return new ModelAndView("error", "message", "ԷϽ ID йȣ ġ ʽϴ.");
		} else {
			UserSession userSession = new UserSession(user);
			request.getSession().setAttribute("userSession", userSession);
			String forwardAction = request.getParameter("forwardAction");
			if (forwardAction != null) {
				response.sendRedirect(forwardAction);
				return null;
			} else {
				return new ModelAndView("index");
			}
		}
	}

}
