/**
 * 
 */
package org.springframework.samples.kyuriboard.web.spring;

import java.util.Map;
import java.util.HashMap;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.Controller;

import org.springframework.samples.kyuriboard.domain.Board;
import org.springframework.samples.kyuriboard.domain.logic.KyuriBoardFacade;

/**
 * @author DAMI(archy712@naver.com)
 *
 */
public class RecomBoardController implements Controller {
	
	private KyuriBoardFacade kyuriBoard;	

	/**
	 * @param kyuriBoard the kyuriBoard to set
	 */
	public void setKyuriBoard(KyuriBoardFacade kyuriBoard) {
		this.kyuriBoard = kyuriBoard;
	}


	/* (non-Javadoc)
	 * @see org.springframework.web.servlet.mvc.Controller#handleRequest(javax.servlet.http.HttpServletRequest, javax.servlet.http.HttpServletResponse)
	 */
	public ModelAndView handleRequest(HttpServletRequest request,
			HttpServletResponse response) throws Exception {
		// TODO Auto-generated method stub
		
		// õ Ų.
		int boardId = new Integer(request.getParameter("boardId")).intValue();
		Board board = this.kyuriBoard.getBoardByBoardId(boardId);
		int curRecom = board.getRecom() + 1;
		board.setRecom(curRecom);
		this.kyuriBoard.updateBoard(board);
		
		//  ü ž
		Map model = new HashMap();
		model.put("board", board);
		
		return new ModelAndView("viewBoard", model);
	}

}
