package net.okjsp.poll;

import java.util.ArrayList;

public class Poll {
	
	private int id; 
	
	private String question;

	private ArrayList<Item> items;


	public void setQuestion(String question) {
		this.question = question;
	}
	
	public String getQuestion() {
		return this.question;
	}

	public ArrayList<Item> getItems() {
		return items;
	}
	
	public void setItems(ArrayList<Item> items) {
		int idx = 0;
		for (Item item : items) {
			item.setId(idx++);
		}
		this.items = items;
	}

	public void setId(int id) {
		this.id = id;
	}

	public int getId() {
		return id;
	}

	public int increment(int itemId) {
		for (Item item : items) {
			if (item.getId() == itemId) {
				item.increment();
				return item.getCount();
			}
		}
		return 0;
	}

	public int getTotalCount() {
		int totalCount = 0;
		for (Item item : items) {
			totalCount+= item.getCount();
		}
		return totalCount;
	}
}
