package net.okjsp.poll;

import java.util.ArrayList;

import junit.framework.TestCase;

public class PollTest extends TestCase {
	
	public void testCreate() {
		Poll poll = new Poll();
		poll.setQuestion("ϴ ?");
		assertEquals("ϴ ?", poll.getQuestion());
		Poll poll2 = new Poll();
		poll2.setQuestion("?");
		assertEquals("?", poll2.getQuestion());
	}
	
	public void testItems() {
		// to-do     ž
		Poll poll = getPoll();
		assertEquals(2, poll.getItems().size());
		Item item = poll.getItems().get(1);
		assertEquals(1, item.getId());
	}

	private Poll getPoll() {
		Poll poll = new Poll();
		ArrayList<Item> items = new ArrayList<Item>();
		items.add(new Item(""));
		items.add(new Item(""));
		poll.setItems(items);
		return poll;
	}
	
	public void testGetTotalCount() {
		Poll poll = getPoll();
		assertEquals(0, poll.getTotalCount());
		poll.getItems().get(1).increment();
		assertEquals(1, poll.getTotalCount());
	}
	
}
