package net.okjsp.poll;

import java.util.ArrayList;

import junit.framework.TestCase;

public class PollServiceTest extends TestCase {
	PollService service;
	@Override
	protected void setUp() throws Exception {
		service = new PollService();
		Poll poll = new Poll();
		ArrayList<Item> items = new ArrayList<Item>();
		items.add(new Item(""));
		items.add(new Item(""));
		poll.setItems(items);

		service.add(poll);
	
		poll = new Poll();
		service.add(poll);
	}

	public void testAdd() {
		assertEquals(2, service.getList().size());
	}
	
	public void test2Add() {
		assertNotNull(service.getList().size());
	}
	
	public void testCountUp() {
		int pollId = 0;
		int itemId = 0;
		service.countUp(pollId, itemId);
		ArrayList<Item> items = service.get(pollId).getItems();
		assertEquals(2, items.size());
		Item item = items.get(itemId);
		assertEquals(1, item.getCount());
		
		service.countUp(pollId, itemId);
		assertEquals(2, item.getCount());
	}
	
}
